/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.profiler.InstanceProfilingTableModel;
import org.boxed_economy.components.profiler.MemoryProfilingTableModel;

public class ProfilerComponent
extends AbstractInternalFrameComponent
implements UpdateClockListener {
    public static final String SEPARATOR = ",";
    private static final String PROFILE_HISTORY_FILENAME = "profiling_history.log.csv";
    private static final String INSTANCE_HISTORY_FILENAME = "instance_history.log.csv";
    private static final String SNAPSHOT_FILENAME = "profiling_snapshot.csv";
    private static final String RUNNING_BUTTON_TEXT = "STOP";
    private static final String STOPPED_BUTTON_TEXT = "START";
    private static final String RUNNNING_STATE_TEXT = "state:RUNNING";
    private static final String STOPPED_STATE_TEXT = "state:STOPPED";
    private static final int RUNNING = 1;
    private static final int STOPPED = 2;
    private InstanceProfilingTableModel instanceModel = new InstanceProfilingTableModel();
    private MemoryProfilingTableModel memoryModel = new MemoryProfilingTableModel();
    private int profilingState = 2;
    private Thread profilingThread = null;
    private long profilingInterval = 500L;
    private int instanceHistoryWritingState = 2;
    private PrintWriter instanceHistoryWriter = new PrintWriter(System.out);
    private long instanceHistoryStepInterval = 10L;
    private long stepCounter = 0L;
    private int memoryHistoryWritingState = 2;
    private Thread memoryHistoryWritingThread = null;
    private PrintWriter memoryHistoryWriter = new PrintWriter(System.out);
    private long memoryHistoryInterval = 30000L;
    private JButton profilingButton = new JButton("START");
    private JTextField profilingIntervalTextField = new JTextField();
    private JLabel profilingStateLabel = new JLabel("state:STOPPED");
    private JTextField memoryHistoryIntervalTextField = new JTextField();
    private JLabel memoryHistoryStateLabel = new JLabel("state:STOPPED");
    private JButton memoryHistoryButton = new JButton("START");
    private JTextField instanceHistoryIntervalTextField = new JTextField();
    private JLabel instanceHistoryStateLabel = new JLabel("state:STOPPED");
    private JButton instanceHistoryButton = new JButton("START");

    public void initialize() {
        try {
            this.addUpdateClockListener(this);
            this.initializeComponents();
        }
        catch (Exception ex) {
            throw new PresentationException(ex);
        }
    }

    protected void initializeDefaultCloseOperation() {
        this.setDefaultCloseOperation(1);
    }

    protected void initializeFrame() {
        this.setTitle("Profiler");
        this.setLocation(100, 100);
        this.setSize(750, 400);
    }

    private void initializeComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel profilerSettingPanel = new JPanel();
        profilerSettingPanel.setLayout(new BorderLayout());
        JPanel pNorthPanel = new JPanel();
        pNorthPanel.add(new JLabel("Profiler"));
        pNorthPanel.add(this.profilingStateLabel);
        profilerSettingPanel.add((Component)pNorthPanel, "North");
        JPanel pCenterPanel = new JPanel();
        pCenterPanel.add(new JLabel("Update Interval(ms)"));
        this.profilingIntervalTextField.setText(Long.toString(this.profilingInterval));
        this.profilingIntervalTextField.setPreferredSize(new Dimension(50, 20));
        pCenterPanel.add(this.profilingIntervalTextField);
        profilerSettingPanel.add((Component)pCenterPanel, "Center");
        this.profilingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilerComponent.this.doTransition();
            }
        });
        profilerSettingPanel.add((Component)this.profilingButton, "South");
        JPanel memoryHistoryPanel = new JPanel();
        memoryHistoryPanel.setLayout(new BorderLayout());
        JPanel msNorthPanel = new JPanel();
        msNorthPanel.add(new JLabel("Memory History"));
        msNorthPanel.add(this.memoryHistoryStateLabel);
        memoryHistoryPanel.add((Component)msNorthPanel, "North");
        JPanel msCenterPanel = new JPanel();
        msCenterPanel.add(new JLabel("Interval(ms)"));
        this.memoryHistoryIntervalTextField.setText(Long.toString(this.memoryHistoryInterval));
        this.memoryHistoryIntervalTextField.setPreferredSize(new Dimension(50, 20));
        msCenterPanel.add(this.memoryHistoryIntervalTextField);
        memoryHistoryPanel.add((Component)msCenterPanel, "Center");
        this.memoryHistoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilerComponent.this.doMemoryStateTransition();
            }
        });
        memoryHistoryPanel.add((Component)this.memoryHistoryButton, "South");
        JPanel instanceHistoryPanel = new JPanel();
        instanceHistoryPanel.setLayout(new BorderLayout());
        JPanel insNorthPanel = new JPanel();
        insNorthPanel.add(new JLabel("Instance History"));
        insNorthPanel.add(this.instanceHistoryStateLabel);
        instanceHistoryPanel.add((Component)insNorthPanel, "North");
        JPanel insCenterPanel = new JPanel();
        insCenterPanel.add(new JLabel("Interval(step)"));
        this.instanceHistoryIntervalTextField.setText(Long.toString(this.instanceHistoryStepInterval));
        this.instanceHistoryIntervalTextField.setPreferredSize(new Dimension(50, 20));
        insCenterPanel.add(this.instanceHistoryIntervalTextField);
        instanceHistoryPanel.add((Component)insCenterPanel, "Center");
        this.instanceHistoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilerComponent.this.doInstanceStateTransition();
            }
        });
        instanceHistoryPanel.add((Component)this.instanceHistoryButton, "South");
        JPanel gcPanel = new JPanel();
        JButton gcButton = new JButton("GC");
        gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runtime.getRuntime().gc();
            }
        });
        JButton snapshotButton = new JButton("SnapShot");
        snapshotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilerComponent.this.snapshot();
            }
        });
        gcPanel.add(gcButton);
        gcPanel.add(snapshotButton);
        JPanel settingPanel = new JPanel();
        settingPanel.add(profilerSettingPanel);
        settingPanel.add(memoryHistoryPanel);
        settingPanel.add(instanceHistoryPanel);
        settingPanel.add(gcPanel);
        JTable instanceTable = new JTable(this.instanceModel);
        JScrollPane instancePanel = new JScrollPane(instanceTable);
        JPanel memoryPanel = new JPanel();
        JTable memoryTable = new JTable(this.memoryModel);
        JScrollPane memoryPane = new JScrollPane(memoryTable);
        memoryPanel.add(new JLabel("Memory State :"));
        memoryPanel.add(memoryPane);
        memoryPanel.setPreferredSize(new Dimension(300, 75));
        container.add((Component)settingPanel, "North");
        container.add((Component)instancePanel, "Center");
        container.add((Component)memoryPanel, "South");
    }

    public void terminate() {
        if (this.memoryHistoryWriter != null) {
            this.memoryHistoryWriter.close();
        }
        if (this.instanceHistoryWriter != null) {
            this.instanceHistoryWriter.close();
        }
        this.removeUpdateClockListener(this);
    }

    public void clockGained(UpdateClockEvent e) {
        if (this.instanceHistoryWritingState == 1) {
            ++this.stepCounter;
            if (this.stepCounter % this.instanceHistoryStepInterval == 0L) {
                this.instanceHistoryWrite();
            }
        }
    }

    private void doTransition() {
        if (this.profilingState == 2) {
            this.startThread();
        } else {
            this.stopThread();
        }
    }

    private void setProfilingState(int state) {
        this.profilingState = state;
        if (state == 1) {
            this.profilingButton.setText(RUNNING_BUTTON_TEXT);
            this.profilingStateLabel.setText(RUNNNING_STATE_TEXT);
        } else if (state == 2) {
            this.profilingButton.setText(STOPPED_BUTTON_TEXT);
            this.profilingStateLabel.setText(STOPPED_STATE_TEXT);
        }
    }

    private void startThread() {
        try {
            this.profilingThread = new Thread(){

                public void run() {
                    try {
                        6 var1_1 = this;
                        synchronized (var1_1) {
                            ProfilerComponent.this.setProfilingState(1);
                            while (ProfilerComponent.this.profilingState == 1) {
                                ProfilerComponent.this.updateViews();
                                this.wait(ProfilerComponent.this.profilingInterval);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            this.profilingInterval = Integer.parseInt(this.profilingIntervalTextField.getText());
            this.profilingThread.start();
        }
        catch (Exception ex) {
            throw new PresentationException(ex);
        }
    }

    private void stopThread() {
        Thread thread = this.profilingThread;
        synchronized (thread) {
            this.setProfilingState(2);
            this.profilingThread.notifyAll();
        }
    }

    private void doMemoryStateTransition() {
        if (this.memoryHistoryWritingState == 2) {
            this.startMemoryHistoryThread();
        } else {
            this.stopMemoryHistoryThread();
        }
    }

    private void setMemoryHistoryState(int state) {
        this.memoryHistoryWritingState = state;
        if (state == 1) {
            this.memoryHistoryButton.setText(RUNNING_BUTTON_TEXT);
            this.memoryHistoryStateLabel.setText(RUNNNING_STATE_TEXT);
        } else if (state == 2) {
            this.memoryHistoryButton.setText(STOPPED_BUTTON_TEXT);
            this.memoryHistoryStateLabel.setText(STOPPED_STATE_TEXT);
        }
    }

    private void startMemoryHistoryThread() {
        try {
            this.memoryHistoryWriter = new PrintWriter(new FileWriter(new File(BESP.boxHome, PROFILE_HISTORY_FILENAME), true));
            this.memoryHistoryWritingThread = new Thread(){

                public void run() {
                    try {
                        7 var1_1 = this;
                        synchronized (var1_1) {
                            ProfilerComponent.this.setMemoryHistoryState(1);
                            while (ProfilerComponent.this.memoryHistoryWritingState == 1) {
                                ProfilerComponent.this.memoryHistoryWrite();
                                this.wait(ProfilerComponent.this.memoryHistoryInterval);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            this.memoryHistoryInterval = Integer.parseInt(this.memoryHistoryIntervalTextField.getText());
            this.memoryHistoryWritingThread.start();
        }
        catch (Exception ex) {
            throw new PresentationException(ex);
        }
    }

    private void stopMemoryHistoryThread() {
        Thread thread = this.memoryHistoryWritingThread;
        synchronized (thread) {
            this.setMemoryHistoryState(2);
            this.memoryHistoryWritingThread.notifyAll();
        }
        if (this.memoryHistoryWriter != null) {
            this.memoryHistoryWriter.close();
            this.memoryHistoryWriter = null;
        }
    }

    private void doInstanceStateTransition() {
        if (this.instanceHistoryWritingState == 2) {
            this.setInstanceHistoryState(1);
        } else {
            this.setInstanceHistoryState(2);
        }
    }

    private void setInstanceHistoryState(int state) {
        try {
            this.instanceHistoryStepInterval = Integer.parseInt(this.instanceHistoryIntervalTextField.getText());
            this.instanceHistoryWritingState = state;
            if (state == 1) {
                this.instanceHistoryWriter = new PrintWriter(new FileWriter(new File(BESP.boxHome, INSTANCE_HISTORY_FILENAME), true));
                this.instanceHistoryButton.setText(RUNNING_BUTTON_TEXT);
                this.instanceHistoryStateLabel.setText(RUNNNING_STATE_TEXT);
            } else if (state == 2) {
                this.instanceHistoryButton.setText(STOPPED_BUTTON_TEXT);
                this.instanceHistoryStateLabel.setText(STOPPED_STATE_TEXT);
                if (this.instanceHistoryWriter != null) {
                    this.instanceHistoryWriter.close();
                    this.instanceHistoryWriter = null;
                }
            }
        }
        catch (IOException ex) {
            throw new PresentationException(ex);
        }
    }

    private void updateViews() {
        this.instanceModel.fireTableDataChanged();
        this.memoryModel.fireTableDataChanged();
    }

    private void memoryHistoryWrite() {
        this.memoryModel.fireTableDataChanged();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getTimeStamp());
        buf.append(this.memoryModel.getModelString());
        this.memoryHistoryWriter.println(buf);
        this.memoryHistoryWriter.flush();
    }

    private void instanceHistoryWrite() {
        System.gc();
        Thread th = new Thread(){

            public void run() {
                ProfilerComponent.this.instanceHistoryWriteImpl();
            }
        };
        th.setPriority(4);
        th.start();
    }

    private void instanceHistoryWriteImpl() {
        this.instanceModel.fireTableDataChanged();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getTimeStamp());
        buf.append(this.instanceModel.getModelString());
        this.instanceHistoryWriter.println(buf);
        this.instanceHistoryWriter.flush();
    }

    private void snapshot() {
        System.gc();
        Thread th = new Thread(){

            public void run() {
                ProfilerComponent.this.snapshotImpl();
            }
        };
        th.setPriority(4);
        th.start();
    }

    private void snapshotImpl() {
        try {
            this.updateViews();
            PrintWriter writer = new PrintWriter(new FileWriter(new File(BESP.boxHome, SNAPSHOT_FILENAME), true));
            StringBuffer buf = new StringBuffer();
            buf.append(this.getTimeStamp());
            buf.append(this.memoryModel.getModelString());
            buf.append(this.instanceModel.getModelString());
            writer.println(buf);
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            throw new PresentationException(ex);
        }
    }

    public String getTimeStamp() {
        StringBuffer buf = new StringBuffer();
        Clock clock = this.getClock();
        Date date = new Date();
        buf.append(date);
        buf.append(SEPARATOR);
        buf.append(clock);
        return buf.toString();
    }

    public Clock getClock() {
        return this.getWorld().getClock();
    }

    public World getWorld() {
        return this.getPresentationContainer().getModelContainer().getModel();
    }
}

