/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.realclock.DaySelectComboBoxModel;
import org.boxed_economy.components.realclock.EndTimeOfDayLimitedTimeRunSetting;
import org.boxed_economy.components.realclock.MonthSelectComboBoxModel;
import org.boxed_economy.components.realclock.RealClockPlugin;
import org.boxed_economy.components.realclock.SetStepNumByEndTimeOfDayCommand;
import org.boxed_economy.components.realclock.TimeOfDay;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;

public class EndTimeOfDayLimitedTimeRunSettingPanel
extends LimitedTimeRunSettingPanel {
    public static ResourceBundle resource = RealClockPlugin.resource;
    private JLabel labelYear = new JLabel();
    private JTextField textFieldEndYear = new JTextField();
    private JLabel labelMonth = new JLabel();
    private JComboBox comboBoxEndMonth = new JComboBox(new MonthSelectComboBoxModel());
    private JLabel labelDay = new JLabel();
    private JComboBox comboBoxEndDay = new JComboBox(new DaySelectComboBoxModel());
    private JLabel labelUntil = new JLabel();
    private FlowLayout flowLayout = new FlowLayout();
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.setPreferredSize(new Dimension(288, 35));
        this.setLayout(this.flowLayout);
        this.flowLayout.setAlignment(0);
        this.labelUntil.setText(resource.getString("Label_Until"));
        this.add((Component)this.labelUntil, null);
        this.textFieldEndYear.setPreferredSize(new Dimension(40, 21));
        this.textFieldEndYear.setHorizontalAlignment(4);
        this.add((Component)this.textFieldEndYear, null);
        this.labelYear.setText(resource.getString("Label_Year"));
        this.add((Component)this.labelYear, null);
        this.comboBoxEndDay.setPreferredSize(new Dimension(40, 21));
        this.add((Component)this.comboBoxEndMonth, null);
        this.labelMonth.setText(resource.getString("Label_Month"));
        this.add((Component)this.labelMonth, null);
        this.comboBoxEndMonth.setPreferredSize(new Dimension(40, 21));
        this.add((Component)this.comboBoxEndDay, null);
        this.add((Component)this.labelDay, null);
        this.labelDay.setText(resource.getString("Label_Day"));
    }

    public String getTitle() {
        return resource.getString("Title_ByEndTimeOfDay");
    }

    public void showCurrentSetting() {
        try {
            EndTimeOfDayLimitedTimeRunSetting currentSetting = (EndTimeOfDayLimitedTimeRunSetting)this.getLimitedTimeRunSetting();
            TimeOfDay newTimeOfDay = currentSetting.getEndTimeOfDay();
            this.textFieldEndYear.setText(String.valueOf(newTimeOfDay.getYear()));
            this.comboBoxEndMonth.setSelectedItem(String.valueOf(newTimeOfDay.getMonth()));
            this.comboBoxEndDay.setSelectedItem(String.valueOf(newTimeOfDay.getDay()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyNewSetting() throws ApplyPropertyException {
        try {
            int year = Integer.parseInt(this.textFieldEndYear.getText());
            int month = Integer.parseInt(this.comboBoxEndMonth.getSelectedItem().toString());
            int day = Integer.parseInt(this.comboBoxEndDay.getSelectedItem().toString());
            if (year <= 0) {
                throw new ApplyPropertyException("illegal year set below zero");
            }
            TimeOfDay endTimeOfDay = new TimeOfDay(year, month, day, 0, 0, 0);
            new SetStepNumByEndTimeOfDayCommand(this.getContainer(), endTimeOfDay).execute();
        }
        catch (NumberFormatException ex) {
            throw new ApplyPropertyException(ex);
        }
        catch (Exception ex) {
            throw new ApplyPropertyException(ex);
        }
    }

    protected boolean isCurrentTimeRunSetting() {
        Class<?> clazz = this.getLimitedTimeRunSetting().getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.components.realclock.EndTimeOfDayLimitedTimeRunSetting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.equals(clazz2);
    }
}

