/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.util.ResourceBundle;
import org.boxed_economy.components.realclock.AbstractRealClockLimitedTimeRunSetting;
import org.boxed_economy.components.realclock.RealClock;
import org.boxed_economy.components.realclock.RealClockPlugin;
import org.boxed_economy.components.realclock.Time;
import org.boxed_economy.components.realclock.TimeOfDay;

public class TimeLimitedTimeRunSetting
extends AbstractRealClockLimitedTimeRunSetting {
    public static ResourceBundle resource = RealClockPlugin.resource;
    public static final Time defaultTime = new Time(0L, "hour");
    private Time runTime = null;

    public TimeLimitedTimeRunSetting(RealClock clock, Time runTime) {
        super(clock);
        this.runTime = runTime;
    }

    public Time getRunTime() {
        return this.runTime;
    }

    public TimeOfDay getEndTimeOfDay() {
        return super.getClock().getCurrentTimeOfDay().getTimeOfDay(this.runTime);
    }

    public String toString() {
        return String.valueOf(this.runTime.getLength()) + this.runTime.getUnit();
    }

    public String getDescription() {
        String labelName = resource.getString("Title_ByTime");
        String labelBy = resource.getString("Label_By");
        return String.valueOf(labelName) + "(" + labelBy + " " + this.runTime + ")";
    }
}

