/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.components.realclock.Time;

public class TimeOfDay
implements Serializable {
    private static final TimeOfDay DEFAULT = new TimeOfDay(1970, 1, 1, 0, 0, 0);
    private GregorianCalendar calendar = null;

    public TimeOfDay(int year, int month, int day, int hour, int minute, int second) {
        this.calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
    }

    private TimeOfDay(GregorianCalendar calendar) {
        this.calendar = calendar;
    }

    public TimeOfDay getTimeOfDay(Time gainTime) {
        long length = gainTime.getLength();
        if (length > Integer.MAX_VALUE) {
            throw new ModelException("hour\u7d4c\u904e() timeOfDay\u3092\u9032\u3081\u3088\u3046\u3068\u3059\u308bhour\u304c\u9577\u3059\u304e\u307e\u3059\u3002");
        }
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        String unit = gainTime.getUnit();
        if (unit.equals("year")) {
            newCalendar.add(1, (int)length);
        } else if (unit.equals("month")) {
            newCalendar.add(2, (int)length);
        } else if (unit.equals("day")) {
            newCalendar.add(5, (int)length);
        } else if (unit.equals("hour")) {
            newCalendar.add(10, (int)length);
        } else if (unit.equals("minute")) {
            newCalendar.add(12, (int)length);
        } else if (unit.equals("second")) {
            newCalendar.add(13, (int)length);
        }
        return new TimeOfDay(newCalendar);
    }

    public Time getTimeDifference(TimeOfDay target) {
        long getTimeDifference\u30df\u30easecond = this.calendar.getTime().getTime() - target.calendar.getTime().getTime();
        return new Time(getTimeDifference\u30df\u30easecond / 1000L, "second");
    }

    public Time getMonthDifference(TimeOfDay target) {
        long myMonth = this.getYear() * 12 + this.getMonth();
        long targetMonth = target.getYear() * 12 + target.getMonth();
        long monthNum = myMonth - targetMonth;
        return new Time(monthNum, "month");
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public TimeOfDay getTimeOfDayByYear(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(1, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public TimeOfDay getMonthTimeOfDayByMonth(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(2, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public TimeOfDay getTimeOfDayByDay(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(5, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public TimeOfDay getTimeOfDayByHour(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(10, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public TimeOfDay getTimeOfDayByMinute(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(12, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public TimeOfDay getTimeOfDayBySecond(int addvalue) {
        GregorianCalendar newCalendar = (GregorianCalendar)this.calendar.clone();
        newCalendar.add(13, addvalue);
        return new TimeOfDay(newCalendar);
    }

    public boolean equals(Object target) {
        return this.calendar.equals(((TimeOfDay)target).calendar);
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }

    public String toString() {
        DateFormat df = DateFormat.getDateTimeInstance();
        return df.format(this.calendar.getTime());
    }
}

