/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.relationview.canvas;

import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.presentation.bface.typeselector.TypeSelection;
import org.boxed_economy.components.relationview.canvas.AbstractRelationViewCanvas;
import org.boxed_economy.components.relationviewer.model.AgentNode;

public class RandomRelationViewCanvas
extends AbstractRelationViewCanvas {
    private static final int CHAR_WIDTH = 6;
    private static final int CHAR_HEIGHT = 6;
    private int margin = 50;
    private int width = 300;
    private int height = 300;
    Random rand = new Random();

    public RandomRelationViewCanvas(TypeSelection agentTypes, TypeSelection relationTypes) {
        super(agentTypes, relationTypes);
    }

    protected void layoutNodes() {
        ArrayList nodes = new ArrayList(super.getOrderedAllNodes());
        this.width = this.getWidth();
        this.height = this.getHeight();
        int amount = nodes.size();
        int radius = (this.width > this.height ? this.height / 2 : this.width / 2) - this.margin;
        Point center = new Point(this.width / 2, this.height / 2);
    }

    private int computeStringLength(String text) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return text.length() * 6;
        }
        return SwingUtilities.computeStringWidth(g.getFontMetrics(), text);
    }

    protected AgentNode addAgentNode(Agent agent) {
        AgentNode node = new AgentNode(agent);
        int x = this.rand.nextInt(this.width - this.margin * 2);
        int y = this.rand.nextInt(this.height - this.margin * 2);
        node.setLocation(new Point(x + this.margin, y + this.margin));
        this.add(node);
        this.nodes.put(agent, node);
        this.getNodes(agent.getType()).add(node);
        return node;
    }
}

