/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.runsetting;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.AbstractCompositeRunSettingPanel;
import org.boxed_economy.components.runsetting.CompositeRunSettingPanelLayout;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;
import org.boxed_economy.components.runsetting.RunSettingManagerPlugin;
import org.boxed_economy.components.runsetting.RunSettingPanel;

public class CompositeLimitedTimeRunSettingPanel
extends AbstractCompositeRunSettingPanel {
    public static ResourceBundle resource = RunSettingManagerPlugin.resource;
    private LimitedTimeRunSettingPanel currentPanel = null;
    private ButtonGroup buttonGroup = null;

    public void add(RunSettingPanel runSettingPanel) {
        if (!(runSettingPanel instanceof LimitedTimeRunSettingPanel)) {
            throw new PresentationException("cannot add because not LimitedTimeRunSettingPanel");
        }
        super.add(runSettingPanel);
    }

    public String getTitle() {
        return resource.getString("Title_LimitedTimeRunSetting");
    }

    public void showCurrentSetting() {
        this.removeAll();
        this.buttonGroup = new ButtonGroup();
        Iterator i = this.getRunSettingPanels().iterator();
        while (i.hasNext()) {
            LimitedTimeRunSettingPanel element = (LimitedTimeRunSettingPanel)i.next();
            this.add(this.createPanel(element));
            element.showCurrentSetting();
        }
    }

    private JPanel createPanel(final LimitedTimeRunSettingPanel element) {
        JPanel panel = new JPanel();
        panel.setLayout(new CompositeRunSettingPanelLayout(2));
        if (element.getTitle() != null) {
            final JRadioButton button = new JRadioButton(element.getTitle());
            this.buttonGroup.add(button);
            button.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem() == button) {
                        CompositeLimitedTimeRunSettingPanel.this.setCurrentPanel(element);
                    }
                }
            });
            if (element.isCurrentTimeRunSetting()) {
                this.buttonGroup.setSelected(button.getModel(), true);
            }
            panel.add(button);
        }
        panel.add(element);
        return panel;
    }

    private void setCurrentPanel(LimitedTimeRunSettingPanel element) {
        Iterator i = this.getRunSettingPanels().iterator();
        while (i.hasNext()) {
            LimitedTimeRunSettingPanel panel = (LimitedTimeRunSettingPanel)i.next();
            if (panel == element) {
                panel.setEnabled(true);
                this.currentPanel = panel;
                continue;
            }
            panel.setEnabled(false);
        }
    }

    public void applyNewSetting() throws ApplyPropertyException {
        if (this.currentPanel != null) {
            this.currentPanel.applyNewSetting();
        }
    }
}

