/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.speedselect;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.boxed_economy.besp.model.ModelThread;
import org.boxed_economy.components.property.PropertyPanel;
import org.boxed_economy.components.speedselect.SpeedSelectComboBoxModel;
import org.boxed_economy.components.speedselect.SpeedSelectModel;
import org.boxed_economy.components.speedselect.SpeedSelectPlugin;

public class SpeedSelectPanel
extends PropertyPanel {
    public static ResourceBundle resource = SpeedSelectPlugin.resource;
    private JComboBox comboBoxSpeedSelect = new JComboBox(new SpeedSelectComboBoxModel());

    public String getTitle() {
        return SpeedSelectPlugin.resource.getString("Title");
    }

    public void initialize() {
        this.setPreferredSize(new Dimension(240, 120));
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.setLayout(layout);
        JLabel labelSpeed = new JLabel();
        labelSpeed.setText(SpeedSelectPlugin.resource.getString("Description"));
        labelSpeed.setPreferredSize(new Dimension(240, 17));
        this.add((Component)labelSpeed, null);
        this.add((Component)this.comboBoxSpeedSelect, null);
    }

    public void showCurrentSetting() {
        long speed = this.getModelThread().getEventDispatchInterval();
        SpeedSelectModel[] models = SpeedSelectModel.speedModels;
        SpeedSelectModel current = models[0];
        int i = 0;
        while (i < models.length) {
            if ((long)models[i].speed > speed) break;
            current = models[i];
            ++i;
        }
        this.comboBoxSpeedSelect.setSelectedItem(current);
    }

    public void applyNewSetting() {
        SpeedSelectModel model = (SpeedSelectModel)this.comboBoxSpeedSelect.getSelectedItem();
        this.getModelThread().setEventDispatchInterval(model.speed);
    }

    public ModelThread getModelThread() {
        return this.getPresentationContainer().getModelContainer().getModelThread();
    }
}

