/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.worldinitializer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.besp.presentation.guifw.CreateComponentAction;
import org.boxed_economy.components.worldinitializer.InitializerTableModel;
import org.boxed_economy.components.worldinitializer.WorldInitializerPlugin;

public class WorldInitializerComponent
extends AbstractInternalFrameComponent
implements BESPPlugin,
SimulationStateListener,
ModelContainerListener {
    private static final Logger logger;
    public static ResourceBundle resource;
    private boolean isChanged = false;
    private Object world = null;
    private List editableFields = null;
    private InitializerTableModel tableModel = null;
    private JTable table = new JTable();
    private JButton button_initialize = new JButton(resource.getString("Init_Button"));
    private JButton button_default = new JButton(resource.getString("Default_Button"));
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.worldinitializer.WorldInitializerComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.components.worldinitializer.WorldInitializerComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
        resource = WorldInitializerPlugin.resource;
    }

    public static void initializePlugin(BESPContainer container) {
        String string = resource.getString("Name_Component");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.worldinitializer.WorldInitializerComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CreateComponentAction createAction = new CreateComponentAction(string, clazz);
        container.getPresentationContainer().addMenuElementToToolsMenu(createAction);
    }

    public void initialize() {
        this.initializeComponents();
    }

    public void terminate() {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldOpened(ModelContainerEvent ev) {
        logger.debug((Object)"OpenWorld");
        this.initializeTargetModel();
        this.initializeTable();
        this.revalidate();
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
    }

    private void initializeComponents() {
        this.setSize(800, 250);
        this.setTitle(resource.getString("Name_Component"));
        JPanel tableButtonPanel = new JPanel();
        this.getContentPane().add((Component)tableButtonPanel, "North");
        tableButtonPanel.add((Component)this.button_default, "East");
        this.button_default.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldInitializerComponent.this.defaultPressed();
            }
        });
        JScrollPane scroll = new JScrollPane(20, 30);
        this.getContentPane().add((Component)scroll, "Center");
        scroll.getViewport().add(this.table);
        JPanel buttonPanel = new JPanel();
        this.button_initialize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldInitializerComponent.this.initializePressed();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        buttonPanel.add((Component)this.button_initialize, null);
        this.updateButtons();
        this.show();
    }

    private void initializeTargetModel() {
        try {
            logger.debug((Object)"InitializeModel");
            this.world = this.getPresentationContainer().getModelContainer().getModel();
            this.editableFields = new ArrayList();
            if (this.world == null) {
                JOptionPane.showMessageDialog(this, resource.getString("No_World_Error"));
            } else {
                BeanInfo info = Introspector.getBeanInfo(this.world.getClass());
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    logger.debug((Object)descriptors[i].getName());
                    if (this.isEditableDiscriptor(descriptors[i])) {
                        logger.debug((Object)("editable>" + descriptors[i].getName()));
                        this.editableFields.add(descriptors[i]);
                    }
                    ++i;
                }
                if (this.editableFields.size() == 0) {
                    JOptionPane.showMessageDialog(this, resource.getString("No_Field_Error"));
                }
            }
        }
        catch (IntrospectionException e) {
            logger.warn((Object)"getting BeanInfo failed", (Throwable)e);
        }
    }

    private void initializeTable() {
        this.table.removeAll();
        this.table.createDefaultColumnsFromModel();
        this.table.setAutoResizeMode(4);
        this.tableModel = new InitializerTableModel(this.world, this.editableFields, this);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                WorldInitializerComponent.this.propertyChanged();
            }
        });
        this.table.setModel(this.tableModel);
    }

    private void updateButtons() {
        int state = this.getPresentationContainer().getModelContainer().getModelThread().getState();
        this.updateButtons(state);
    }

    private void updateButtons(int state) {
        if (!this.isChanged) {
            this.button_initialize.setEnabled(false);
            this.button_default.setEnabled(false);
        } else if (state == 3) {
            this.button_initialize.setEnabled(false);
            this.button_default.setEnabled(true);
        } else {
            this.button_initialize.setEnabled(true);
            this.button_default.setEnabled(true);
        }
    }

    private boolean isEditableDiscriptor(PropertyDescriptor descriptor) {
        return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null && Modifier.isPublic(descriptor.getReadMethod().getModifiers()) && Modifier.isPublic(descriptor.getWriteMethod().getModifiers()) && descriptor.getWriteMethod().getParameterTypes().length == 1 && descriptor.getPropertyType() == descriptor.getWriteMethod().getParameterTypes()[0] && descriptor.getPropertyType().isPrimitive();
    }

    private void defaultPressed() {
        int result = JOptionPane.showInternalConfirmDialog(this, resource.getString("Cancel_Dialog"), resource.getString("Confirm_Cancel"), 0);
        if (result == 0) {
            this.tableModel.applyDefaultProperties();
            this.button_default.setEnabled(false);
        }
    }

    private void initializePressed() {
        try {
            World newWorld = (World)this.world.getClass().newInstance();
            List values = this.tableModel.getNewValues();
            if (!$assertionsDisabled && this.editableFields.size() != values.size()) {
                throw new AssertionError((Object)resource.getString("Assert_mes"));
            }
            int result = JOptionPane.showInternalConfirmDialog(this, resource.getString("Init_Dialog"), resource.getString("Confirm_Init"), 0);
            if (result == 0) {
                int i = 0;
                while (i < values.size()) {
                    PropertyDescriptor p = (PropertyDescriptor)this.editableFields.get(i);
                    logger.info((Object)(String.valueOf(p.getName()) + ":" + p.getWriteMethod().getName() + ":" + values.get(i).getClass().getName() + ":" + values.get(i).toString()));
                    ((PropertyDescriptor)this.editableFields.get(i)).getWriteMethod().invoke((Object)newWorld, values.get(i));
                    ++i;
                }
                this.getPresentationContainer().getModelContainer().setModel(newWorld);
                this.isChanged = false;
                this.button_default.setEnabled(false);
                this.button_initialize.setEnabled(false);
            }
        }
        catch (InstantiationException e) {
            String mes = resource.getString("Instantiation_Error");
            logger.warn((Object)mes, (Throwable)e);
            this.getPresentationContainer().showError(mes, e);
        }
        catch (IllegalAccessException ex) {
            logger.warn((Object)"getter is not accessable.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            logger.warn((Object)"getter invokation failed", (Throwable)ex);
        }
    }

    private void propertyChanged() {
        this.isChanged = true;
        this.updateButtons();
    }

    public void simulationStarted(SimulationStateEvent ev) {
        logger.debug((Object)"thread RUNNING");
        this.updateButtons(this.getPresentationContainer().getModelContainer().getModelThread().getState());
    }

    public void simulationStopped(SimulationStateEvent ev) {
        logger.debug((Object)"thread stop");
        this.updateButtons(this.getPresentationContainer().getModelContainer().getModelThread().getState());
    }

    public void simulationStopping(SimulationStateEvent ev) {
        this.updateButtons(this.getPresentationContainer().getModelContainer().getModelThread().getState());
    }
}

