/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.action;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.modeldesigner.action.MEGenerateAction;
import org.boxed_economy.componentbuilder.modeldesigner.codegen.Config;
import org.boxed_economy.componentbuilder.modeldesigner.codegen.MEInformationCodegenHelper;
import org.boxed_economy.componentbuilder.modeldesigner.model.MEDocument;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPart;
import trier.model.core.TClass;
import trier.model.core.TPackage;

public class MEGenerateInformationAction
extends MEGenerateAction {
    public static final String ID = "generate_information";
    public static final String DISPLAY_TEXT = "Generate Information Code";
    public static final String TOOLTIP_TEXT = "Generate Information Code";
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.modeldesigner.action.MEGenerateInformationAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public MEGenerateInformationAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setId(ID);
        this.setText("Generate Information Code");
        this.setToolTipText("Generate Information Code");
    }

    protected void generate(JETEmitter emitter, MEDocument document) throws CoreException, InvocationTargetException, InterruptedException {
        List informationImpls = document.getAllInformationImpl();
        if (this.hasSameInformation(informationImpls)) {
            MessageDialog dialog = new MessageDialog(this.getEditorPart().getSite().getShell(), "Code Generation Failed", null, "This model has same name informations.Rename it and try again.", 4, new String[]{"OK"}, 0);
            dialog.open();
            return;
        }
        Iterator i = informationImpls.iterator();
        while (i.hasNext()) {
            TClass informationImpl = (TClass)i.next();
            IContainer container = document.getTargetContainer((TPackage)informationImpl.getNamespace());
            MEInformationCodegenHelper model = new MEInformationCodegenHelper(informationImpl);
            if (!model.isValidGeneralization()) {
                MessageDialog dialog = new MessageDialog(this.getEditorPart().getSite().getShell(), "Code Generation Failed", null, String.valueOf(informationImpl.getName()) + " has some super types.", 4, new String[]{"OK"}, 0);
                dialog.open();
                return;
            }
            Config config = this.createConfig(model, informationImpl.getNamespace().getName(), informationImpl.getName(), container.getFullPath().toString());
            this.executeGenerator(config);
        }
    }

    private boolean hasSameInformation(List informationImpls) {
        HashSet<String> names = new HashSet<String>();
        Iterator i = informationImpls.iterator();
        while (i.hasNext()) {
            TClass information = (TClass)i.next();
            if (names.contains(information.getName())) {
                return true;
            }
            names.add(information.getName());
        }
        return false;
    }

    protected String getTemplateURI() {
        return "templates/Information.javajet";
    }
}

