/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.CBException;
import org.boxed_economy.componentbuilder.CBPlugin;
import org.boxed_economy.componentbuilder.modeldesigner.MEEditor;
import org.boxed_economy.componentbuilder.modeldesigner.model.MEDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import sdeditor.model.SDDocument;
import sdeditor.model.serialize.SDDocumentSerializer;
import trier.classdiagram.editpart.CDClassEditPart;
import trier.diagrameditor.model.EElement;
import trier.model.core.TClass;
import trier.model.core.TPackage;

public class MEOpenBehaviorEditorAction
extends SelectionAction {
    public static final String ID = "open_behavior";
    public static final String DISPLAY_TEXT = "Open Behavior Designer";
    public static final String TOOLTIP_TEXT = "Open Behavior Designer";
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.modeldesigner.action.MEOpenBehaviorEditorAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public MEOpenBehaviorEditorAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setId(ID);
        this.setText("Open Behavior Designer");
        this.setToolTipText("Open Behavior Designer");
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object o = this.getSelectedObjects().get(0);
        if (!(o instanceof CDClassEditPart)) {
            return false;
        }
        TClass tClass = this.getTClass();
        return tClass.getStereoType().equals((Object)this.getDocument().getDefinedStereoType("behavior type"));
    }

    public void run() {
        TClass tBehavior = this.getTClass();
        IFile file = this.creteNewBehaviorFile(tBehavior);
        try {
            if (!file.exists()) {
                file.create(this.getInitialContents(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.openResource((IResource)file);
        }
        catch (Exception e) {
            logger.warn((Object)("open behavior failed." + tBehavior), (Throwable)e);
        }
    }

    private IFile creteNewBehaviorFile(TClass tBehavior) {
        MEDocument document = this.getDocument();
        IFile file = document.getTargetContainer((TPackage)tBehavior.getNamespace()).getFile((IPath)new Path(String.valueOf(tBehavior.getName()) + ".behavior"));
        return file;
    }

    protected InputStream getInitialContents() {
        try {
            SDDocumentSerializer serializer = SDDocumentSerializer.createInstance();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            serializer.serialize(new SDDocument(), output);
            output.close();
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Exception ex) {
            throw new CBException("file initializing error", ex);
        }
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = CBPlugin.getDefault().getActivePage()) != null && (display = activePage.getActiveEditor().getSite().getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        activePage.openEditor((IFile)resource);
                    }
                    catch (PartInitException e) {
                        logger.warn((Object)"open file failed", (Throwable)e);
                    }
                }
            });
        }
    }

    private TClass getTClass() {
        return (TClass)((EElement)((CDClassEditPart)this.getSelectedObjects().get(0)).getModel()).getTModel();
    }

    private MEDocument getDocument() {
        return (MEDocument)((MEEditor)this.getEditorPart()).getEEditDomain().getDocument();
    }
}

