/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.boxed_economy.componentbuilder.modeldesigner.codegen.Config;
import org.boxed_economy.componentbuilder.modeldesigner.codegen.MyJETEmitter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGen;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JMerger;

public class JETGateway {
    private Config mConfig = null;

    public JETGateway(Config config) {
        this.mConfig = config;
    }

    public String generate(IProgressMonitor monitor) throws CoreException {
        monitor = this.createIfNull(monitor);
        Config config = this.getConfig();
        MyJETEmitter emitter = new MyJETEmitter(config.getTemplateFullUri());
        Iterator i = config.getClasspathVariable().iterator();
        while (i.hasNext()) {
            emitter.addClasspathVariable(i.next().toString(), config.getPluginId());
        }
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        String result = emitter.generate((IProgressMonitor)sub, new Object[]{config.getModel()});
        monitor.worked(1);
        return result;
    }

    public String merge(IProgressMonitor monitor, String emitterResult) throws CoreException {
        Config config;
        IContainer container = this.findOrCreateContainer(monitor = this.createIfNull(monitor), (config = this.getConfig()).getTargetFolder(), config.getPackageName());
        if (container == null) {
            throw new JETException("Cound not find or create container for package " + config.getPackageName() + " in " + config.getTargetFolder());
        }
        IFile targetFile = container.getFile((IPath)new Path(config.getTargetFile()));
        if (!targetFile.exists()) {
            monitor.worked(1);
            return emitterResult;
        }
        JMerger jMerger = new JMerger();
        jMerger.setControlModel(new JControlModel(config.getMergeXmlFullUri()));
        jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
        String oldContents = jMerger.getTargetCompilationUnit().getContents();
        jMerger.merge();
        monitor.worked(1);
        String result = jMerger.getTargetCompilationUnit().getContents();
        if (oldContents == null || oldContents.equals(result)) {
            return result;
        }
        if (!targetFile.isReadOnly()) {
            return result;
        }
        if (targetFile.getWorkspace().validateEdit(new IFile[]{targetFile}, (Object)new SubProgressMonitor(monitor, 1)).isOK()) {
            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
            jMerger.remerge();
            return jMerger.getTargetCompilationUnit().getContents();
        }
        return result;
    }

    public IFile save(IProgressMonitor monitor, byte[] contents) throws CoreException {
        Config config;
        IContainer container = this.findOrCreateContainer(monitor = this.createIfNull(monitor), (config = this.getConfig()).getTargetFolder(), config.getPackageName());
        if (container == null) {
            throw new JETException("Cound not find or create container for package " + config.getPackageName() + " in " + config.getTargetFolder());
        }
        IFile targetFile = container.getFile((IPath)new Path(config.getTargetFile()));
        IFile result = this.getWritableTargetFile(targetFile, container, config.getTargetFile());
        ByteArrayInputStream newContents = new ByteArrayInputStream(contents);
        if (result.exists()) {
            result.setContents((InputStream)newContents, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            result.create((InputStream)newContents, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return result;
    }

    private IProgressMonitor createIfNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    private IContainer findOrCreateContainer(IProgressMonitor progressMonitor, String targetDirectory, String packageName) throws CoreException {
        Path outputPath = new Path(String.valueOf(targetDirectory) + "/");
        progressMonitor.beginTask("", 4);
        SubProgressMonitor sub = new SubProgressMonitor(progressMonitor, 1);
        IPath localLocation = null;
        IContainer container = CodeGen.findOrCreateContainer((IPath)outputPath, (boolean)true, localLocation, (IProgressMonitor)sub);
        return container;
    }

    private IFile getWritableTargetFile(IFile targetFile, IContainer container, String fileName) {
        if (targetFile.isReadOnly()) {
            if (this.getConfig().isForceOverwrite()) {
                targetFile.setReadOnly(false);
            } else {
                targetFile = container.getFile((IPath)new Path("." + fileName + ".new"));
            }
        }
        return targetFile;
    }

    protected Config getConfig() {
        return this.mConfig;
    }
}

