/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.model;

import diagrammodelfw.model.DElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.model.EElement;
import trier.model.core.TClass;
import trier.model.core.TElement;
import trier.model.core.TModelElement;
import trier.model.core.TStereoType;

public class MEDocument
extends CDDocument {
    public static final String INFORMATION_IMPL = "information class";
    public static final String INFORMATION = "information type";
    public static final String RELATION = "relation type";
    public static final String BEHAVIOR = "behavior type";
    public static final String GOODS = "goods type";
    public static final String AGENT = "agent type";
    public static final String[] DEFAULT_STEREO_TYPES = new String[]{"information type", "information class", "agent type", "relation type", "behavior type", "goods type"};
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.modeldesigner.model.MEDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public MEDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
    }

    public EElement createNodeElement(String nodeType) {
        if (nodeType.equals(AGENT)) {
            return this.createAgent("NewAgent");
        }
        if (nodeType.equals(BEHAVIOR)) {
            return this.createBehavior("NewBehavior");
        }
        if (nodeType.equals(GOODS)) {
            return this.createGoods("NewGoods");
        }
        if (nodeType.equals(INFORMATION)) {
            return this.createInformation("NewInformation");
        }
        if (nodeType.equals(INFORMATION_IMPL)) {
            return this.createInformationImpl("NewInformationClass");
        }
        if (nodeType.equals(RELATION)) {
            return this.createRelation("NewRelation");
        }
        return super.createNodeElement(nodeType);
    }

    private EElement createAgent(String name) {
        return this.createFmFwElement(name, AGENT);
    }

    private EElement createGoods(String name) {
        return this.createFmFwElement(name, GOODS);
    }

    private EElement createBehavior(String name) {
        return this.createFmFwElement(name, BEHAVIOR);
    }

    private EElement createRelation(String name) {
        return this.createFmFwElement(name, RELATION);
    }

    private EElement createInformation(String name) {
        return this.createFmFwElement(name, INFORMATION);
    }

    private EElement createInformationImpl(String name) {
        return this.createFmFwElement(name, INFORMATION_IMPL);
    }

    private EElement createFmFwElement(String name, String type) {
        EElement eClass = super.createClass(name);
        TClass tClass = (TClass)eClass.getTModel();
        TStereoType stereoType = this.getDefinedStereoType(type);
        this.getTDocument().setStereoType((TModelElement)tClass, stereoType);
        return eClass;
    }

    public List getAllInformationImpl() {
        return this.getDefinedStereoType(INFORMATION_IMPL).getStereoTypedElements();
    }

    public List getAllInformationType() {
        return this.getDefinedStereoType(INFORMATION).getStereoTypedElements();
    }

    public List getAllAgentType() {
        return this.getDefinedStereoType(AGENT).getStereoTypedElements();
    }

    public List getAllGoodsType() {
        return this.getDefinedStereoType(GOODS).getStereoTypedElements();
    }

    public List getAllRelationType() {
        return this.getDefinedStereoType(RELATION).getStereoTypedElements();
    }

    public List getAllBehaviorType() {
        return this.getDefinedStereoType(BEHAVIOR).getStereoTypedElements();
    }

    public List getAllType() {
        ArrayList allType = new ArrayList();
        allType.addAll(this.getAllAgentType());
        allType.addAll(this.getAllBehaviorType());
        allType.addAll(this.getAllRelationType());
        allType.addAll(this.getAllInformationType());
        allType.addAll(this.getAllGoodsType());
        return allType;
    }
}

