/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.typeeditor;

import java.util.Iterator;
import java.util.List;
import org.boxed_economy.componentbuilder.typeeditor.CBTypeGroup;
import org.boxed_economy.componentbuilder.typeeditor.TypeModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CBChoicableTypeGroup
extends CBTypeGroup {
    private Combo typeNamesCombo;
    private Button typeNameEnableButton;
    private String typeFQCN;

    public CBChoicableTypeGroup(Composite composite, String typeName, String typeFQCN) {
        super(composite, typeName);
        this.typeFQCN = typeFQCN;
    }

    protected void initializeComponents(Group group) {
        this.listWidth = 330;
        this.createNewGroup((Composite)group);
        this.createChoiceGroup((Composite)group);
        this.createListGroup((Composite)group);
    }

    protected void createChoiceGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.typeNameEnableButton = new Button(composite, 32);
        this.typeNameEnableButton.setText("Key : ");
        GridData griddata = new GridData();
        griddata.widthHint = 60;
        this.typeNameEnableButton.setLayoutData((Object)griddata);
        this.typeNameEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CBChoicableTypeGroup.this.selectionChanged(e);
            }
        });
        this.typeNamesCombo = new Combo(composite, 2056);
        griddata = new GridData();
        griddata.widthHint = this.listWidth - 20 + 15;
        this.typeNamesCombo.setLayoutData((Object)griddata);
        this.selectionChanged(null);
    }

    public void setTypeNames(List typeNames) {
        this.typeNamesCombo.removeAll();
        Iterator i = typeNames.iterator();
        while (i.hasNext()) {
            this.addTypeName((String)i.next());
        }
    }

    public void addTypeName(String typeName) {
        this.typeNamesCombo.add(typeName);
    }

    protected void pushNewButton(SelectionEvent e) {
        String typeIdentifier = null;
        StatusInfo status = new StatusInfo(0, "");
        String name = this.nameText.getText();
        if (this.typeNameEnableButton.getSelection()) {
            int index = this.typeNamesCombo.getSelectionIndex();
            if (index >= 0) {
                typeIdentifier = this.typeNamesCombo.getItem(index);
            } else {
                status = new StatusInfo(4, "class selection is null");
            }
        } else {
            typeIdentifier = name;
        }
        typeIdentifier = "\"" + typeIdentifier + "\"";
        if (name.length() > 0) {
            String fullName = String.valueOf(this.getTypePrefix()) + name;
            TypeModel typeModel = new TypeModel(fullName, typeIdentifier);
            if (!this.list.getObjects().contains(typeModel)) {
                this.list.add(typeModel);
                this.nameText.setText("");
            } else {
                status = new StatusInfo(4, "the same name already exists");
            }
        } else {
            status = new StatusInfo(4, "empty name");
        }
        ErrorDialog.openError((Shell)this.nameText.getShell(), (String)"Error", (String)"Cannot add the Type", (IStatus)status);
    }

    protected void selectionChanged(SelectionEvent e) {
        this.typeNamesCombo.setEnabled(this.typeNameEnableButton.getSelection());
    }

    public String getTypeFQCN() {
        return this.typeFQCN;
    }
}

