/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.typeeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.boxed_economy.componentbuilder.typeeditor.CBChoicableTypeGroup;
import org.boxed_economy.componentbuilder.typeeditor.CBJDTUtil;
import org.boxed_economy.componentbuilder.typeeditor.CBTypeGroup;
import org.boxed_economy.componentbuilder.typeeditor.FindTypeASTVisitor;
import org.boxed_economy.componentbuilder.typeeditor.TypeModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sdeditor.codegen.SDCodeGenerationUtil;
import sdeditor.util.JavaSearchUtil;

public class CBCreateTypeWizardPage
extends WizardPage {
    private static final String CLASS_NAME_LABEL_STR = "Class : ";
    private static final String PACKAGE_NAME_LABEL_STR = "Package : ";
    private static final String PLUGIN_CLASS_NAME = "BESPPlugin";
    private static final String MODEL_CONTAINER_NAME = "modelContainer";
    private static final String AGENT_TYPE = "AgentType";
    private static final String GOODS_TYPE = "GoodsType";
    private static final String RELATION_TYPE = "RelationType";
    private static final String BEHAVIOR_TYPE = "BehaviorType";
    private static final String INFORMATION_TYPE = "InformationType";
    private static final String FQCN_BEHAVIOR = "org.boxed_economy.besp.model.fmfw.Behavior";
    private static final String FQCN_INFORMATION = "org.boxed_economy.besp.model.fmfw.Information";
    private static final String PLUGIN_CLASS_FQCN = "org.boxed_economy.besp.container.BESPPlugin";
    private static final String IMPORT_CONTAINER = "org.boxed_economy.besp.container.*";
    private static final String IMPORT_MODEL_ = "org.boxed_economy.besp.model.*";
    private static final String IMPORT_MODEL_FMFW = "org.boxed_economy.besp.model.fmfw.*";
    private static final String[] IMPORTS = new String[]{"org.boxed_economy.besp.container.*", "org.boxed_economy.besp.model.*", "org.boxed_economy.besp.model.fmfw.*"};
    private IDOMFactory domFactory = new DOMFactory();
    private IJavaElement jelem = null;
    private ICompilationUnit unit = null;
    private IType type = null;
    private CBTypeGroup agentTypeGroup = null;
    private CBTypeGroup goodsTypeGroup = null;
    private CBTypeGroup relationTypeGroup = null;
    private CBChoicableTypeGroup behaviorTypeGroup = null;
    private CBChoicableTypeGroup informationTypeGroup = null;
    private Text packageNameText = null;
    private Text classNameText = null;

    public CBCreateTypeWizardPage(String name) {
        super(name);
    }

    public void init(IStructuredSelection selection) {
        this.jelem = CBJDTUtil.getInitialJavaElement(selection);
        this.unit = CBJDTUtil.getCompilationUnit(this.jelem);
        this.type = CBJDTUtil.getType(this.jelem, PLUGIN_CLASS_NAME);
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createTypeNameGroup(parent);
        this.initializeTypeGroups(parent);
        parent.pack();
        this.setControl((Control)parent);
        this.initializePackageText();
        this.initializeClassText();
        this.initializeTypes();
        if (this.unit != null && this.type == null) {
            this.setErrorMessage("This class is not BESPPlugin");
            this.setPageComplete(false);
            this.classNameText.setText(this.unit.getElementName());
            this.classNameText.setEnabled(false);
            this.agentTypeGroup.setEnabled(false);
            this.goodsTypeGroup.setEnabled(false);
            this.relationTypeGroup.setEnabled(false);
            this.behaviorTypeGroup.setEnabled(false);
            this.informationTypeGroup.setEnabled(false);
        }
    }

    private void createTypeNameGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label packageLabel = new Label(composite, 0);
        packageLabel.setText(PACKAGE_NAME_LABEL_STR);
        packageLabel.setAlignment(1024);
        this.packageNameText = new Text(composite, 2048);
        GridData griddata = new GridData();
        griddata.widthHint = 300;
        this.packageNameText.setLayoutData((Object)griddata);
        Label classLabel = new Label(composite, 0);
        classLabel.setText(CLASS_NAME_LABEL_STR);
        classLabel.setAlignment(1024);
        this.classNameText = new Text(composite, 2048);
        griddata = new GridData();
        griddata.widthHint = 200;
        this.classNameText.setLayoutData((Object)griddata);
    }

    private void initializeTypeGroups(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.agentTypeGroup = new CBTypeGroup(composite, AGENT_TYPE);
        this.goodsTypeGroup = new CBTypeGroup(composite, GOODS_TYPE);
        this.relationTypeGroup = new CBTypeGroup(composite, RELATION_TYPE);
        composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.behaviorTypeGroup = new CBChoicableTypeGroup(composite, BEHAVIOR_TYPE, FQCN_BEHAVIOR);
        this.informationTypeGroup = new CBChoicableTypeGroup(composite, INFORMATION_TYPE, FQCN_INFORMATION);
    }

    private void initializePackageText() {
        IPackageFragment pack = null;
        if (this.jelem.getElementType() == 4) {
            pack = (IPackageFragment)this.jelem;
        } else if (this.jelem.getElementType() == 5) {
            pack = (IPackageFragment)this.unit.getParent();
        }
        if (pack != null) {
            this.packageNameText.setText(pack.getElementName());
            this.packageNameText.setEnabled(false);
        }
    }

    private void initializeClassText() {
        if (this.type != null) {
            this.classNameText.setText(this.type.getElementName());
            this.classNameText.setEnabled(false);
        }
    }

    private void initializeTypes() {
        if (this.type != null) {
            CompilationUnit cunit = AST.parseCompilationUnit((ICompilationUnit)this.unit, (boolean)true);
            FindTypeASTVisitor visitor = new FindTypeASTVisitor();
            cunit.accept((ASTVisitor)visitor);
            this.initializeType(this.agentTypeGroup, visitor.getParsedTypes());
            this.initializeType(this.goodsTypeGroup, visitor.getParsedTypes());
            this.initializeType(this.relationTypeGroup, visitor.getParsedTypes());
            this.initializeType(this.behaviorTypeGroup, visitor.getParsedTypes());
            this.initializeType(this.informationTypeGroup, visitor.getParsedTypes());
        }
        this.initializeTypeClasses(this.behaviorTypeGroup);
        this.initializeTypeClasses(this.informationTypeGroup);
    }

    private void initializeType(CBTypeGroup typeGroup, Map typeIdentifiers) {
        try {
            ArrayList<TypeModel> types = new ArrayList<TypeModel>();
            String typeName = typeGroup.getTypeName();
            IField[] fields = this.type.getFields();
            int i = 0;
            while (i < fields.length) {
                String signature;
                String type;
                if (fields[i].getFlags() == 9 && (type = (signature = fields[i].getTypeSignature()).substring(1, signature.length() - 1)).endsWith(typeName)) {
                    TypeModel typeModel = new TypeModel(fields[i].getElementName(), (String)typeIdentifiers.get(fields[i].getElementName()));
                    types.add(typeModel);
                }
                ++i;
            }
            typeGroup.getList().setObjects(types);
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
    }

    private void initializeTypeClasses(CBChoicableTypeGroup group) {
        String fqcn = group.getTypeFQCN();
        List types = JavaSearchUtil.findSubtypes(fqcn, false, this.jelem.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
        new ArrayList();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            IType type = (IType)i.next();
            group.addTypeName(type.getFullyQualifiedName());
        }
    }

    protected void generateCode(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Generating Code", 100);
        monitor.subTask("Creating CompilationUnit");
        this.prepareUnit((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        String clName = this.type.getElementName();
        String oldContents = this.unit.getBuffer().getContents();
        IDOMCompilationUnit domUnit = this.domFactory.createCompilationUnit(oldContents, "root");
        monitor.subTask("Preparing and Cleaning Class");
        IDOMNode node = domUnit.getFirstChild();
        while (node != null) {
            IDOMNode next = node.getNextNode();
            if (node.getNodeType() == 3) {
                boolean matched = false;
                int i = 0;
                while (i < IMPORTS.length) {
                    if (node.getName().equals(IMPORTS[i])) {
                        matched = true;
                    }
                    ++i;
                }
                if (matched) {
                    node.remove();
                }
            }
            node = next;
        }
        monitor.worked(5);
        IDOMType rootType = null;
        rootType = (IDOMType)domUnit.getChild(clName);
        if (rootType == null) {
            rootType = this.domFactory.createClass();
            rootType.setFlags(1);
            rootType.setName(clName);
            rootType.setSuperInterfaces(new String[]{PLUGIN_CLASS_NAME});
            domUnit.addChild((IDOMNode)rootType);
        }
        rootType.setComment("\n\n" + rootType.getComment());
        monitor.worked(5);
        IDOMMethod initializeTypesMethod = null;
        IDOMNode node2 = rootType.getFirstChild();
        while (node2 != null) {
            IDOMMember member;
            IDOMNode next = node2.getNextNode();
            if (node2 instanceof IDOMMember && ((member = (IDOMMember)node2).getFlags() & 0x10) != 16) {
                node2.remove();
            }
            if (node2 instanceof IDOMMethod && node2.getName().equals("initializeTypes")) {
                initializeTypesMethod = (IDOMMethod)node2;
            }
            node2 = next;
        }
        monitor.worked(10);
        monitor.subTask("Generating ...");
        int i = 0;
        while (i < IMPORTS.length) {
            IDOMImport impt = this.domFactory.createImport();
            impt.setName(IMPORTS[i]);
            rootType.insertSibling((IDOMNode)impt);
            ++i;
        }
        monitor.worked(5);
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n //Get the model container  \n ModelContainer modelContainer = container.getModelContainer();\n\n");
        this.createFields(rootType, this.agentTypeGroup, buffer);
        this.createFields(rootType, this.goodsTypeGroup, buffer);
        this.createFields(rootType, this.relationTypeGroup, buffer);
        this.createFields(rootType, this.behaviorTypeGroup, buffer);
        this.createFields(rootType, this.informationTypeGroup, buffer);
        monitor.worked(15);
        IDOMMethod initializer = this.domFactory.createMethod();
        initializer.setComment("\n /** \n * This method will be modified automatically by Type Editor \n */");
        initializer.setName("initializePlugin");
        initializer.setParameters(new String[]{"BESPContainer"}, new String[]{"container"});
        initializer.setBody("{installTypes(container);initializeTypes(container);}");
        initializer.setFlags(9);
        rootType.addChild((IDOMNode)initializer);
        monitor.worked(5);
        initializer = this.domFactory.createMethod();
        initializer.setComment("\n\n /** \n * This method will be modified automatically by Type Editor \n */");
        initializer.setName("installTypes");
        initializer.setParameters(new String[]{"BESPContainer"}, new String[]{"container"});
        initializer.setBody("{" + buffer.toString() + "}");
        initializer.setFlags(10);
        rootType.addChild((IDOMNode)initializer);
        monitor.worked(5);
        initializer = initializeTypesMethod;
        if (initializer == null) {
            initializer = this.domFactory.createMethod();
            initializer.setName("initializeTypes");
            initializer.setParameters(new String[]{"BESPContainer"}, new String[]{"container"});
            initializer.setBody("{}");
            initializer.setFlags(10);
        }
        initializer.setComment("\n\n");
        rootType.addChild((IDOMNode)initializer);
        monitor.worked(5);
        String contents = domUnit.getContents();
        String formattedContents = SDCodeGenerationUtil.format(contents, this.unit);
        this.unit.getBuffer().setContents(formattedContents);
        this.unit.save((IProgressMonitor)new SubProgressMonitor(monitor, 25), true);
        monitor.done();
    }

    private boolean prepareUnit(IProgressMonitor monitor) throws Exception {
        if (this.type == null) {
            IPackageFragmentRoot root = this.getPackageRoot(this.jelem.getJavaProject());
            IPackageFragment pack = root.createPackageFragment(this.packageNameText.getText(), false, monitor);
            String clName = this.classNameText.getText();
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add(PLUGIN_CLASS_FQCN);
            this.type = CBJDTUtil.createType(clName, null, interfaces, root, pack, monitor);
            this.unit = this.type.getCompilationUnit();
            monitor.done();
            return true;
        }
        monitor.done();
        return true;
    }

    private void createFields(IDOMType rootType, CBTypeGroup group, StringBuffer buffer) {
        List types = group.getList().getObjects();
        int j = 0;
        while (j < types.size()) {
            TypeModel typeModel = (TypeModel)types.get(j);
            IDOMField field = this.domFactory.createField();
            field.setType(group.getTypeName());
            field.setName(typeModel.getName());
            field.setFlags(9);
            rootType.addChild((IDOMNode)field);
            buffer.append(String.valueOf(typeModel.getName()) + " = " + MODEL_CONTAINER_NAME + ".install" + group.getTypeName() + "(" + typeModel.getIdentifier() + ");\n");
            ++j;
        }
    }

    private IPackageFragmentRoot getPackageRoot(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public boolean checkCanFinish() {
        StatusInfo status = new StatusInfo(0, "");
        if (this.packageNameText.getText().length() <= 0) {
            status = new StatusInfo(4, "package name is empty");
        }
        if (this.packageNameText.getText().endsWith(".")) {
            status = new StatusInfo(4, "package name is invalid");
        }
        if (this.classNameText.getText().length() <= 0) {
            status = new StatusInfo(4, "class name is empty");
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Cannot add the Type", (IStatus)status);
        return status.getSeverity() == 0;
    }

    public IType getType() {
        return this.type;
    }
}

