/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.typeeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.componentbuilder.typeeditor.TypeModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sdeditor.util.ObjectList;

public class CBTypeGroup {
    protected String typeName;
    protected ObjectList list;
    protected Text nameText;
    protected int listWidth = 190;

    public CBTypeGroup(Composite composite, String typeName) {
        this.typeName = typeName;
        this.initialize(composite);
    }

    protected void initialize(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.typeName);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        this.initializeComponents(group);
    }

    protected void initializeComponents(Group group) {
        this.createNewGroup((Composite)group);
        this.createListGroup((Composite)group);
    }

    protected void createNewGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label prefixLabel = new Label(composite, 0);
        prefixLabel.setText(this.getTypePrefix());
        prefixLabel.setAlignment(131072);
        GridData griddata = new GridData();
        griddata.widthHint = 110;
        prefixLabel.setLayoutData((Object)griddata);
        this.nameText = new Text(composite, 2048);
        GridData griddata2 = new GridData();
        griddata2.widthHint = 90;
        this.nameText.setLayoutData((Object)griddata2);
        Button newButton = new Button(composite, 8);
        newButton.setText("Add");
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CBTypeGroup.this.pushNewButton(e);
            }
        });
        griddata = new GridData();
        griddata.widthHint = 50;
        newButton.setLayoutData((Object)griddata);
    }

    protected void createListGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.list = new ObjectList(composite, 2818);
        GridData griddata = new GridData();
        griddata.widthHint = this.listWidth;
        griddata.heightHint = 150;
        this.list.setLayoutData(griddata);
        this.list.setObjects(new ArrayList());
        Button removeButton = new Button(composite, 8);
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CBTypeGroup.this.pushRemoveButton(e);
            }
        });
        GridData griddata2 = new GridData();
        griddata2.widthHint = 50;
        removeButton.setLayoutData((Object)griddata2);
    }

    protected void pushNewButton(SelectionEvent e) {
        StatusInfo status = new StatusInfo(0, "");
        String name = this.nameText.getText();
        if (name.length() > 0) {
            String fullName = String.valueOf(this.getTypePrefix()) + name;
            TypeModel typeModel = new TypeModel(fullName, "\"" + name + "\"");
            if (!this.list.getObjects().contains(typeModel)) {
                this.list.add(typeModel);
                this.nameText.setText("");
            } else {
                status = new StatusInfo(4, "the same name already exists");
            }
        } else {
            status = new StatusInfo(4, "empty name");
        }
        ErrorDialog.openError((Shell)this.nameText.getShell(), (String)"Error", (String)"Cannot add the Type", (IStatus)status);
    }

    private void pushRemoveButton(SelectionEvent e) {
        List removeObjects = this.list.getSelectionObjects();
        Iterator i = removeObjects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            this.list.remove(object);
        }
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.nameText.setEnabled(enabled);
    }

    public ObjectList getList() {
        return this.list;
    }

    public String getTypeName() {
        return this.typeName;
    }

    protected String getTypePrefix() {
        return String.valueOf(this.typeName.toUpperCase()) + "_";
    }
}

