/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;

public class JavaSearchUtil {
    public static List findSubtypes(String fqcn, boolean allowSameType, IJavaProject project, IProgressMonitor monitor) {
        try {
            monitor.beginTask("find types", 100);
            IType type = project.findType(fqcn);
            if (type == null) {
                return Collections.EMPTY_LIST;
            }
            monitor.worked(20);
            ITypeHierarchy hierarchy = type.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
            List<IType> types = Arrays.asList(hierarchy.getAllSubtypes(type));
            if (!allowSameType) {
                JavaSearchUtil.trimSameType(types, type);
            }
            monitor.worked(10);
            return types;
        }
        catch (Exception ex) {
            throw new WorldComposerException("error in finding subtypes", ex);
        }
    }

    private static void trimSameType(List types, IType theType) {
        Iterator i = types.iterator();
        while (i.hasNext()) {
            IType type = (IType)i.next();
            if (!type.equals(theType)) continue;
            i.remove();
        }
    }
}

