/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.codegen;

import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCArgument;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorConstants;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorCore;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;

public class WCCodeGenerationUtil {
    private WCCodeGeneratorCore generator;

    public WCCodeGenerationUtil(WCCodeGeneratorCore generator) {
        this.generator = generator;
    }

    public String exInvokeMethod(String target, String method, WCArgument aug) {
        if (aug == null) {
            aug = new WCArgument();
        }
        return String.valueOf(target) + "." + method + aug.toString();
    }

    public String exStringLiteral(String s) {
        String cr;
        String quotationConvertedValue = s.replaceAll(String.valueOf('\"'), "'");
        String crConvertedValue = quotationConvertedValue.replaceAll(cr = WCCodeGeneratorConstants.CR, "\"+System.getProperty(\"line.separator\")+\"");
        if (crConvertedValue.endsWith("+\"")) {
            crConvertedValue.substring(crConvertedValue.length() - 3);
        }
        return "\"" + crConvertedValue + "\"";
    }

    public String exDeclaration(String type, String name) {
        return String.valueOf(this.generator.getClassName(type)) + " " + name;
    }

    public String exSubstitute(String left, String right) {
        return String.valueOf(left) + "=" + right;
    }

    public Object exLoggerInfo(String string) {
        return this.exInvokeMethod("logger", "info", new WCArgument(this.exStringLiteral(string)));
    }

    public String exNewInstance(String type, WCArgument aug) {
        if (aug == null) {
            aug = new WCArgument();
        }
        return "new " + this.generator.getClassName(type) + aug.toString();
    }

    public WCArgument createTypeArgument(WCTypeModel type) {
        String typeName = this.generator.getClassName(type.getModelFQCN());
        return new WCArgument(String.valueOf(typeName) + "." + type.getTypeName());
    }

    public WCArgument createRelationTypeArgument(WCTypeModel type, String agent) {
        String typeName = this.generator.getClassName(type.getModelFQCN());
        WCArgument argument = new WCArgument(String.valueOf(typeName) + "." + type.getTypeName());
        argument.addStatement(agent);
        return argument;
    }
}

