/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.codegen;

import java.util.Collections;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorCore;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import sdeditor.codegen.SDCodeGenerationEnvironment;
import sdeditor.codegen.SDCodeGenerationUtil;
import sdeditor.codegen.SDCodeGenerator;

public class WCCodeGenerator
extends SDCodeGenerator {
    private IType worldType = null;
    private SDCodeGenerationEnvironment env = null;
    private WCDocument document;

    public WCCodeGenerator(WCDocument document) {
        this.document = document;
    }

    public void generate(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 2);
        this.initializeEnvironment();
        this.generateWorld(new SubProgressMonitor(monitor, 2));
        EditorUtility.openInEditor((Object)this.worldType);
    }

    private void initializeEnvironment() throws Exception {
        this.env = new SDCodeGenerationEnvironment(this.getFile());
    }

    private void generateWorld(SubProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 100);
        monitor.setTaskName("Generating World Java Code");
        monitor.subTask("Preparing World Java File");
        this.prepareWorldType((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 25));
        ICompilationUnit compilationUnit = this.worldType.getCompilationUnit();
        compilationUnit.save((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 15), true);
        String contents = compilationUnit.getBuffer().getContents();
        monitor.subTask("Generating Contents");
        WCCodeGeneratorCore generator = new WCCodeGeneratorCore(this.getWorldClassName(), this.document);
        String newContents = generator.generateContents(new SubProgressMonitor((IProgressMonitor)monitor, 0), contents);
        monitor.worked(25);
        monitor.subTask("Formatting");
        String formattedContents = SDCodeGenerationUtil.format(newContents, compilationUnit);
        monitor.worked(25);
        monitor.subTask("Saving");
        compilationUnit.getBuffer().setContents(formattedContents);
        compilationUnit.save((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 15), true);
        if (compilationUnit.isOpen()) {
            compilationUnit.close();
        }
        compilationUnit.open((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 15));
        SDCodeGenerationUtil.organizeImport(compilationUnit);
        compilationUnit.save((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 15), true);
        monitor.done();
    }

    private void prepareWorldType(IProgressMonitor monitor) throws Exception {
        try {
            String packageName = this.env.getPackage().getElementName();
            this.worldType = this.env.getJavaProject().findType(packageName, this.getWorldClassName());
            if (this.worldType == null) {
                this.worldType = SDCodeGenerationUtil.createType(this.getWorldClassName(), WorldComposerPlugin.FQCN_WORLD, Collections.EMPTY_LIST, this.env, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        Object var3_5 = null;
        monitor.done();
    }

    private String getWorldClassName() {
        return this.document.getWorldTemplate().getName();
    }
}

