/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.codegen;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.boxed_economy.componentbuilder.codegen.CBNameMapper;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCBlock;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorConstants;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCIDOMElementFactory;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCMemberGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class WCCodeGeneratorCore {
    private String worldName = null;
    private WCDocument document = null;
    private WCIDOMElementFactory elementFactory;
    private CBNameMapper mapper;
    private IDOMCompilationUnit domUnit = null;
    private IDOMType type = null;
    private IDOMType oldType = null;
    private WCMemberGroup forBesp;
    private WCMemberGroup constants;
    private WCMemberGroup variables;
    private WCBlock initializeGenerator;
    private WCBlock createAgentsBlock;
    private WCBlock addRelationsBlock;
    private WCMemberGroup createAgentsSubroutines;
    private WCMemberGroup addRelationsSubroutines;
    private WCMemberGroup accessors;
    private Set imports = new TreeSet();
    private Map informationFactories = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WCCodeGeneratorCore(String string, WCDocument document) {
        this.worldName = string;
        this.document = document;
        this.elementFactory = new WCIDOMElementFactory(this);
        this.mapper = new CBNameMapper();
    }

    public String generateContents(SubProgressMonitor monitor, String oldContents) {
        this.initializeDOM(oldContents);
        this.initializeType();
        this.initializeMemberGroup();
        this.processGenerators();
        this.processParameters();
        this.processAgentGroups();
        this.processRelationGroups();
        this.composeStaticMembersForBESP();
        this.composeConstants();
        this.composeVariables();
        this.composeInitialize();
        this.composeCreateAgentsSubroutines();
        this.composeAddRelationsSubroutines();
        this.composeWorldDescription();
        this.composeInformationFactory();
        this.composeRandomUtility();
        this.composeAccessor();
        this.composeImports();
        return this.domUnit.getContents();
    }

    private void initializeDOM(String oldContents) {
        this.domUnit = this.elementFactory.createCompilationUnit(oldContents, "root");
    }

    private void initializeType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.jdom.IDOMType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.type = (IDOMType)this.findNode((IDOMNode)this.domUnit, this.worldName, clazz);
        if (this.type != null) {
            this.oldType = this.type;
            this.oldType.remove();
        }
        this.type = this.elementFactory.createType(this.worldName);
        this.domUnit.addChild((IDOMNode)this.type);
    }

    private void initializeMemberGroup() {
        this.forBesp = new WCMemberGroup(this.type);
        this.forBesp.setComment("Class variable and main method for running on the besp");
        this.constants = new WCMemberGroup(this.type);
        this.constants.setComment("Constants for Random Number Generator");
        this.variables = new WCMemberGroup(this.type);
        this.variables.setComment("Parameters");
        this.accessors = new WCMemberGroup(this.type);
        this.accessors.setComment(WCCodeGeneratorConstants.BLOCK_NAME_ACCESORS);
        this.initializeGenerator = new WCBlock();
        this.initializeGenerator.setComment(WCCodeGeneratorConstants.COMMENT_GENERATOR);
        this.createAgentsBlock = new WCBlock();
        this.addRelationsBlock = new WCBlock();
        this.createAgentsSubroutines = new WCMemberGroup(this.type);
        this.createAgentsSubroutines.setComment(WCCodeGeneratorConstants.BLOCK_NAME_FOR_CREATE_AGENTS_SUB);
        this.addRelationsSubroutines = new WCMemberGroup(this.type);
        this.addRelationsSubroutines.setComment(WCCodeGeneratorConstants.BLOCK_NAME_FOR_ADD_REALTIONS_SUB);
    }

    private void composeImports() {
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (this.domUnit.getChild(name) != null) continue;
            IDOMImport iimport = this.elementFactory.createImport();
            iimport.setName(name);
            this.type.insertSibling((IDOMNode)iimport);
        }
    }

    private void processGenerators() {
        List generators = this.document.getWorldTemplate().getRandomNumberGeneratorSettings();
        ListIterator i = generators.listIterator();
        while (i.hasNext()) {
            WCRandomNumberGeneratorSetting setting = (WCRandomNumberGeneratorSetting)i.next();
            WCParameter seed = new WCParameter(String.valueOf(setting.getName()) + "Seed", setting.getSeed());
            if (setting.getName().equals("defaultRandom")) continue;
            IDOMMember randomKey = this.elementFactory.createRandomNumberGeneratorKey(setting);
            this.constants.addStatement(randomKey);
            this.initializeGenerator.addStatement(this.elementFactory.getInstallRandomNumberGeneratorStatement(setting, seed));
            IDOMMember randomSeed = this.elementFactory.createRandomSeedVariable(setting, seed);
            if (!i.hasPrevious()) {
                randomSeed.setComment(String.valueOf(WCCodeGeneratorConstants.CR) + "seed for generating random number." + WCCodeGeneratorConstants.CR);
            }
            this.variables.addStatement(randomSeed);
            IDOMMember getter = this.elementFactory.createGetter(this.getNameMapper().getName(seed), "long");
            this.accessors.addStatement(getter);
            IDOMMember setter = this.elementFactory.createSetter(this.getNameMapper().getName(seed), "long");
            this.accessors.addStatement(setter);
        }
    }

    private void processParameters() {
        List parameters = this.document.getWorldTemplate().getParameters();
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            WCParameter parameter = (WCParameter)i.next();
            IDOMMember parameterDeclaration = this.elementFactory.createParameterVariable(parameter);
            this.variables.addStatement(parameterDeclaration);
            IDOMMember getter = this.elementFactory.createGetter(this.mapper.getName(parameter), parameter.getType());
            this.accessors.addStatement(getter);
            IDOMMember setter = this.elementFactory.createSetter(this.mapper.getName(parameter), parameter.getType());
            this.accessors.addStatement(setter);
            IDOMMember descriptor = this.elementFactory.createParameterDescription(this.mapper.getName(parameter), parameter.getDescription());
            this.accessors.addStatement(descriptor);
        }
    }

    private void processAgentGroups() {
        List agentGroups = this.document.getWorldTemplate().getAgentGroups();
        ArrayList<IDOMMethod> createAgentSub = new ArrayList<IDOMMethod>();
        ListIterator i = agentGroups.listIterator();
        while (i.hasNext()) {
            IDOMMethod method;
            WCAgentGroup agentGroup = (WCAgentGroup)i.next();
            IDOMMember agentGroupListDeclaration = this.elementFactory.createAgentListVariable(agentGroup);
            if (i.previousIndex() == 0) {
                agentGroupListDeclaration.setComment(String.valueOf(WCCodeGeneratorConstants.CR) + "//List of agents created from AgentGroup" + WCCodeGeneratorConstants.CR);
            }
            this.variables.addStatement(agentGroupListDeclaration);
            if (agentGroup.getNumber().getValueAsString().equals("0")) continue;
            if (agentGroup.getNumber().getValueAsString().equals("1")) {
                this.createAgentsBlock.addStatement(this.elementFactory.createInvokeCreateAgentStatement(agentGroup));
            } else {
                this.createAgentsBlock.addStatement(this.elementFactory.createInvokeCreateAgentsStatement(agentGroup));
            }
            if (!agentGroup.getNumber().getValueAsString().equals("0") && !agentGroup.getNumber().getValueAsString().equals("1")) {
                method = this.elementFactory.createAgentsSub(agentGroup);
                this.createAgentsSubroutines.addStatement((IDOMMember)method);
            }
            method = this.elementFactory.createAgentSub(agentGroup);
            createAgentSub.add(method);
        }
        this.createAgentsSubroutines.addStatements(createAgentSub);
    }

    private void processRelationGroups() {
        Iterator i = this.document.getWorldTemplate().getRelationGroups().iterator();
        while (i.hasNext()) {
            WCRelationGroup relationGroup = (WCRelationGroup)i.next();
            this.addRelationsBlock.addStatement(this.elementFactory.createInvokeAddRelationStatement(relationGroup));
            this.addRelationsSubroutines.addStatement((IDOMMember)this.elementFactory.createAddRelationsSubroutine(relationGroup));
        }
    }

    private void composeStaticMembersForBESP() {
        IDOMField serialID = this.elementFactory.createSerialIDField();
        this.forBesp.addStatement((IDOMMember)serialID);
        IDOMField logger = this.elementFactory.createLoggerField();
        this.forBesp.addStatement((IDOMMember)logger);
        IDOMMethod main = this.elementFactory.createMainMethod();
        this.forBesp.addStatement((IDOMMember)main);
        this.forBesp.compose();
    }

    private void composeConstants() {
        this.constants.compose();
    }

    private void composeVariables() {
        this.variables.compose();
    }

    private void composeInitialize() {
        IDOMMethod initializeByHands;
        WCMemberGroup initialize = new WCMemberGroup(this.type);
        initialize.setComment("Initialize");
        IDOMMethod initializeWorld = this.elementFactory.createInitializeWorld(this.initializeGenerator);
        initialize.addStatement((IDOMMember)initializeWorld);
        IDOMMethod initializeAgents = this.elementFactory.createInitializeAgents();
        initialize.addStatement((IDOMMember)initializeAgents);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.jdom.IDOMMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((initializeByHands = (IDOMMethod)this.findNode((IDOMNode)this.oldType, "initializeByHands", clazz)) == null) {
            initializeByHands = this.elementFactory.createInitializeByHands();
        } else {
            initializeByHands.remove();
        }
        initialize.addStatement((IDOMMember)initializeByHands);
        IDOMMethod createAgents = this.elementFactory.createCreateAgents(this.createAgentsBlock);
        initialize.addStatement((IDOMMember)createAgents);
        IDOMMethod addRelations = this.elementFactory.createAddRelations(this.addRelationsBlock);
        initialize.addStatement((IDOMMember)addRelations);
        initialize.compose();
    }

    private void composeCreateAgentsSubroutines() {
        this.createAgentsSubroutines.compose();
    }

    private void composeAddRelationsSubroutines() {
        this.addRelationsSubroutines.compose();
    }

    private void composeWorldDescription() {
        WCMemberGroup descriptions = new WCMemberGroup(this.type);
        descriptions.setComment(WCCodeGeneratorConstants.BLOCK_NAME_DESCRIPTION);
        IDOMMethod name = this.elementFactory.createGetName(this.document.getWorldTemplate().getName());
        descriptions.addStatement((IDOMMember)name);
        IDOMMethod description = this.elementFactory.createGetDescription(this.document.getWorldTemplate().getDescription());
        descriptions.addStatement((IDOMMember)description);
        descriptions.compose();
    }

    private void composeInformationFactory() {
        if (!this.informationFactories.isEmpty()) {
            WCMemberGroup factories = new WCMemberGroup(this.type);
            boolean isRecycled = false;
            Iterator i = this.informationFactories.keySet().iterator();
            while (i.hasNext()) {
                IDOMMethod factory;
                String factoryName = (String)i.next();
                String implName = (String)this.informationFactories.get(factoryName);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.jdom.IDOMMethod");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((factory = (IDOMMethod)this.findNode((IDOMNode)this.oldType, factoryName, clazz)) == null) {
                    factory = this.elementFactory.createInformationFactory(factoryName, implName);
                } else {
                    isRecycled = true;
                    factory.remove();
                }
                factories.addStatement((IDOMMember)factory);
            }
            if (!isRecycled) {
                factories.setComment(WCCodeGeneratorConstants.BLOCK_NAME_FACTORY);
            }
            factories.compose();
        }
    }

    private void composeRandomUtility() {
        WCMemberGroup random = new WCMemberGroup(this.type);
        random.setComment(WCCodeGeneratorConstants.BLOCK_NAME_RANDOM_UTILITY);
        IDOMMethod doubleQuantity = this.elementFactory.createGetDoubleRandomQuantity();
        random.addStatement((IDOMMember)doubleQuantity);
        IDOMMethod intQuantity = this.elementFactory.createGetIntRandomQuantity();
        random.addStatement((IDOMMember)intQuantity);
        IDOMMethod longQuantity = this.elementFactory.createGetLongRandomQuantity();
        random.addStatement((IDOMMember)longQuantity);
        IDOMMethod electedNumberExclude = this.elementFactory.createGenerateElectedRandomNumberExcluded();
        random.addStatement((IDOMMember)electedNumberExclude);
        IDOMMethod isElected = this.elementFactory.createIsElected();
        random.addStatement((IDOMMember)isElected);
        random.compose();
    }

    private void composeAccessor() {
        this.accessors.compose();
    }

    private IDOMNode findNode(IDOMNode parent, String name, Class type) {
        Enumeration e = parent.getChildren();
        while (e.hasMoreElements()) {
            IDOMNode node = (IDOMNode)e.nextElement();
            if (!node.getName().equals(name) || !type.isInstance(node)) continue;
            return node;
        }
        return null;
    }

    public String getClassName(String fqcn) {
        this.addImport(fqcn);
        return this.trimToClass(fqcn);
    }

    private String trimToClass(String fqcn) {
        int index = fqcn.lastIndexOf(".");
        if (index == -1) {
            return fqcn;
        }
        return fqcn.substring(index + 1);
    }

    private void addImport(String importName) {
        if (importName != null && importName.length() > 0 && importName.indexOf(".") > 0) {
            this.imports.add(importName);
        }
    }

    public void addInformationFactory(String factoryName, String implName) {
        this.informationFactories.put(factoryName, implName);
    }

    public WCDocument getDocument() {
        return this.document;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public CBNameMapper getNameMapper() {
        return this.mapper;
    }
}

