/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCAgentGroupDialog;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCAgentGroupTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCElementTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class WCAgentGroupTableEditComposite
extends WCTableEditComposite {
    private WCElementTableEditor tableEditor;

    public WCAgentGroupTableEditComposite(Composite parent, int style, WCDocument document) {
        super(parent, style, document);
    }

    protected void initializeTableEditor() {
        this.tableEditor = new WCAgentGroupTableEditor(this.getDocument(), this);
    }

    protected List getElements() {
        return this.getDocument().getWorldTemplate().getAgentGroups();
    }

    protected WCElementTableEditor getTableEditor() {
        return this.tableEditor;
    }

    protected void addButtonPushed(SelectionEvent e) {
        List agentTypes = this.getDocument().getProject().getAgentTypes();
        if (agentTypes.isEmpty()) {
            StatusInfo status = new StatusInfo(4, "This project has no AgentTypes. Set classpath to Model file and reload project.");
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Can not create dialog. ", (IStatus)status);
            return;
        }
        WCTypeModel defaultType = (WCTypeModel)agentTypes.get(0);
        WCAgentGroup agentGroup = new WCAgentGroup("NewAgentGroup", defaultType, this.getDocument(), WCAgentGroup.DEFAULT_VALUE);
        WCAgentGroupDialog dialog = new WCAgentGroupDialog(this.getShell(), this.getDocument(), agentGroup);
        int result = dialog.open();
        if (result == 0) {
            WCAgentGroup newAgentGroup = dialog.getAgentGroup();
            this.getDocument().addAgentGroup(newAgentGroup);
            this.getTableViewer().refresh();
            this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)newAgentGroup));
            super.updateButtonsStateChanged();
        }
    }

    protected void modifyButtonPushed(SelectionEvent e) {
        TableItem[] items = this.getTableViewer().getTable().getSelection();
        if (items.length == 0) {
            return;
        }
        WCAgentGroup editingAgentGroup = (WCAgentGroup)items[0].getData();
        WCAgentGroupDialog dialog = new WCAgentGroupDialog(this.getShell(), this.getDocument(), editingAgentGroup);
        dialog.open();
        this.getTableViewer().refresh();
    }

    protected void removeButtonPushed(SelectionEvent e) {
        TableItem[] selectedItems = this.getTableViewer().getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            WCAgentGroup agentGroup = (WCAgentGroup)selectedItems[i].getData();
            this.getDocument().removeAgentGroup(agentGroup);
            ++i;
        }
        this.getTableViewer().refresh();
    }

    protected void moveDown(Object target) {
        this.getDocument().moveDownAgentGroup((WCAgentGroup)target);
    }

    protected void moveUp(Object target) {
        this.getDocument().moveUpAgentGroup((WCAgentGroup)target);
    }
}

