/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.Arrays;
import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCOrderChangeTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCValuedExpressionDialogCellEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCAgentGroupTableEditor
extends WCOrderChangeTableEditor {
    public WCAgentGroupTableEditor(WCDocument document, WCTableEditComposite composite) {
        super(document, composite);
    }

    protected Object getElements() {
        return this.getDocument().getWorldTemplate().getAgentGroups();
    }

    protected void updateTable() {
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Description", "Number"};
    }

    protected int[] getColumnWidth() {
        return new int[]{110, 240, 100};
    }

    protected CellEditor[] getCellEditors() {
        Table table = super.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.getColumnNames().length];
        editors[0] = new TextCellEditor((Composite)table);
        editors[1] = null;
        editors[2] = new WCValuedExpressionDialogCellEditor(table, 0, this.getDocument());
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new AgentGroupCellModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCAgentGroupTableEditor.this.getDocument().getWorldTemplate().getAgentGroups().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new AgentGroupLabelProvider();
    }

    class AgentGroupCellModifier
    implements ICellModifier {
        Table table;

        public boolean canModify(Object element, String property) {
            WCAgentGroupTableEditor.this.getTableViewer().getCellEditors()[2].deactivate();
            return !property.equals("Description");
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(WCAgentGroupTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            Object result = null;
            WCAgentGroup agentGroup = (WCAgentGroup)element;
            switch (columnIndex) {
                case 0: {
                    result = agentGroup.getName();
                    break;
                }
                case 1: {
                    result = agentGroup.toString();
                    break;
                }
                case 2: {
                    result = agentGroup.getNumber();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(WCAgentGroupTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCAgentGroup agentGroup = (WCAgentGroup)item.getData();
            switch (columnIndex) {
                case 0: {
                    if (value.toString().equals("")) {
                        StatusInfo status = new StatusInfo(4, "The name is blank. Input name.");
                        ErrorDialog.openError((Shell)WCAgentGroupTableEditor.this.getTableViewer().getTable().getShell(), (String)"Error", (String)"Can not modify agent group. ", (IStatus)status);
                        break;
                    }
                    WCAgentGroupTableEditor.this.getDocument().setName(agentGroup, value.toString());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    WCValuedExpression valueObject = (WCValuedExpression)WCAgentGroupTableEditor.this.getTableViewer().getCellEditors()[2].getValue();
                    WCAgentGroupTableEditor.this.getDocument().setNumber(agentGroup, valueObject);
                    break;
                }
                default: {
                    return;
                }
            }
            WCAgentGroupTableEditor.this.getTableViewer().update((Object)agentGroup, null);
        }
    }

    class AgentGroupLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AgentGroupLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCAgentGroup agentGroup = (WCAgentGroup)element;
            switch (columnIndex) {
                case 0: {
                    result = agentGroup.getName();
                    break;
                }
                case 1: {
                    result = agentGroup.toString();
                    break;
                }
                case 2: {
                    result = agentGroup.getNumber().getValueAsString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

