/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class WCElementTableEditor {
    private TableViewer tableViewer;
    private WCDocument document;

    public WCElementTableEditor(WCDocument document) {
        this.document = document;
    }

    public void createControl(Composite parent, int style) {
        this.initializeTable(parent, style);
        this.initializeHeader();
        this.initializeTableItem();
        this.updateTable();
    }

    protected void initializeTable(Composite composite, int style) {
        this.tableViewer = new TableViewer(composite, style);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.getColumnNames());
        this.tableViewer.setCellEditors(this.getCellEditors());
        this.tableViewer.setCellModifier(this.getCellModifiers());
        this.tableViewer.setContentProvider(this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        Table table = this.tableViewer.getTable();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCElementTableEditor.this.tableSelected(e);
            }
        };
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)listener);
    }

    protected void initializeHeader() {
        String[] columns = this.getColumnNames();
        int[] columnWidth = this.getColumnWidth();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(this.tableViewer.getTable(), 16384);
            column.setWidth(columnWidth[i]);
            column.setText(columns[i]);
            ++i;
        }
    }

    protected void initializeTableItem() {
        this.getTableViewer().setInput(this.getElements());
    }

    protected abstract void updateTable();

    public void stateChanged() {
    }

    protected WCDocument getDocument() {
        return this.document;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected abstract String[] getColumnNames();

    protected abstract Object getElements();

    protected abstract int[] getColumnWidth();

    protected abstract CellEditor[] getCellEditors();

    protected abstract ICellModifier getCellModifiers();

    protected abstract IContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract void tableSelected(SelectionEvent var1);
}

