/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCInformationSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCInformationSettingTableEditor
extends WCSettingTableEditor {
    public static final String COLUMN_INFORMATION_TYPE = "InformationType";
    public static final String COLUMN_INFORMATION_IMPL = "Implementation";
    public static final String[] INFORMATION_COLUMN_NAMES = new String[]{"InformationType", "Implementation"};
    public static final int[] INFORMATION_COLUMN_WIDTH = new int[]{345, 430};
    private Map editingInformationSettings;
    private Map informationImpls;

    public WCInformationSettingTableEditor(WCDocument document, WCAgentGroup editingAgentGroup) {
        super(document, editingAgentGroup);
        this.initializeInformationImpls();
    }

    private void initializeInformationImpls() {
        this.informationImpls = new HashMap();
        List informationImplList = this.getDocument().getProject().getInformationImplTypes();
        Iterator i = informationImplList.iterator();
        while (i.hasNext()) {
            IType informationImpl = (IType)i.next();
            this.informationImpls.put(informationImpl.getFullyQualifiedName(), informationImpl);
        }
    }

    protected Object getElements() {
        return this.editingInformationSettings;
    }

    protected void initializeTableItem() {
        List informationTypes = this.getDocument().getProject().getInformationTypes();
        this.editingInformationSettings = new TreeMap();
        Iterator i = informationTypes.iterator();
        while (i.hasNext()) {
            WCTypeModel informationType = (WCTypeModel)i.next();
            IType informationImpl = (IType)this.getDocument().getProject().getInformationImplTypes().get(0);
            this.editingInformationSettings.put(new WCInformationSetting(informationType, this.getDocument(), informationImpl), informationImpl);
        }
        this.getTableViewer().setInput((Object)this.editingInformationSettings);
    }

    protected void updateTable() {
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int index = 0;
        while (index < items.length) {
            WCInformationSetting defalutSetting = (WCInformationSetting)items[index].getData();
            List informationSettings = this.getEditingAgentGroup().getInformationSettings();
            Iterator i = informationSettings.iterator();
            while (i.hasNext()) {
                WCInformationSetting informationSetting = (WCInformationSetting)i.next();
                WCTypeModel hadType = informationSetting.getType();
                if (!hadType.equals(defalutSetting.getType())) continue;
                informationSetting.getInformationImpl();
                items[index].setChecked(true);
                this.editingInformationSettings.put(informationSetting, informationSetting.getInformationImpl());
            }
            ++index;
        }
        this.getTableViewer().refresh();
    }

    public void performFinish() {
        ArrayList<WCInformationSetting> informationSettings = new ArrayList<WCInformationSetting>();
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                WCInformationSetting setting = (WCInformationSetting)items[i].getData();
                informationSettings.add(setting);
                this.getDocument().setInformationImpl(setting, (IType)this.editingInformationSettings.get(setting));
            }
            ++i;
        }
        this.getDocument().setInformationSettings(this.getEditingAgentGroup(), informationSettings);
    }

    protected String getTitle() {
        return "Information";
    }

    protected String[] getColumnNames() {
        return INFORMATION_COLUMN_NAMES;
    }

    protected int[] getColumnWidth() {
        return INFORMATION_COLUMN_WIDTH;
    }

    private String[] getInformationImplNames() {
        String[] names = new String[this.informationImpls.size()];
        int count = 0;
        Iterator i = this.informationImpls.keySet().iterator();
        while (i.hasNext()) {
            names[count] = (String)i.next();
            ++count;
        }
        return names;
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[INFORMATION_COLUMN_NAMES.length];
        editors[0] = null;
        editors[1] = new ComboBoxCellEditor((Composite)table, this.getInformationImplNames(), 12);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new InformationSettingCellModifier(this.getTableViewer().getTable());
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCInformationSettingTableEditor.this.editingInformationSettings.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new InformationSettingLabelProvider();
    }

    class InformationSettingCellModifier
    implements ICellModifier {
        Table table;

        public InformationSettingCellModifier(Table table) {
            this.table = table;
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(WCInformationSettingTableEditor.COLUMN_INFORMATION_TYPE);
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(INFORMATION_COLUMN_NAMES);
            int columnIndex = columnNames.indexOf(property);
            Object result = null;
            WCInformationSetting informationSetting = (WCInformationSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = informationSetting.getType().toString();
                    break;
                }
                case 1: {
                    String stringValue = informationSetting.getInformationImplFQCN();
                    List<String> choices = Arrays.asList(WCInformationSettingTableEditor.this.getInformationImplNames());
                    int index = choices.indexOf(stringValue);
                    result = new Integer(index);
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(INFORMATION_COLUMN_NAMES);
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCInformationSetting informationSetting = (WCInformationSetting)item.getData();
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    String valueString = WCInformationSettingTableEditor.this.getInformationImplNames()[(Integer)value].trim();
                    IType type = (IType)WCInformationSettingTableEditor.this.informationImpls.get(valueString);
                    WCInformationSettingTableEditor.this.editingInformationSettings.put(informationSetting, type);
                    item.setChecked(true);
                    break;
                }
                default: {
                    return;
                }
            }
            WCInformationSettingTableEditor.this.getTableViewer().update((Object)informationSetting, null);
        }
    }

    class InformationSettingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        InformationSettingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCInformationSetting informationSetting = (WCInformationSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = informationSetting.getType().toString();
                    break;
                }
                case 1: {
                    result = ((IType)WCInformationSettingTableEditor.this.editingInformationSettings.get(informationSetting)).getFullyQualifiedName();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

