/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCElementTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class WCTableEditComposite
extends Composite {
    private WCDocument document;
    private Button upOrderButton;
    private Button downOrderButton;
    private Button addButton;
    private Button removeButton;
    private Button modifyButton;
    private Table table;
    private TableViewer tableViewer;
    private boolean canModifyByDialog = true;

    public WCTableEditComposite(Composite parent, int style, WCDocument document, boolean canModify) {
        super(parent, style);
        this.canModifyByDialog = canModify;
        this.document = document;
        this.createControl(this);
    }

    public WCTableEditComposite(Composite parent, int style, WCDocument document) {
        super(parent, style);
        this.document = document;
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createTableEditComposite(parent);
        this.createEditButtonsCompsite(parent);
        this.updateButtonsStateChanged();
    }

    private void createTableEditComposite(Composite parent) {
        Composite tableEditComposte = new Composite(parent, 0);
        tableEditComposte.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        tableEditComposte.setLayout((Layout)layout);
        this.createChangeOrderComposite(tableEditComposte);
        this.initializeTableEditor();
        WCElementTableEditor tableEditor = this.getTableEditor();
        tableEditor.createControl(tableEditComposte, 68354);
    }

    private void createChangeOrderComposite(Composite parent) {
        Composite changeOrderComposite = new Composite(parent, 0);
        GridData changeOrderGrid = new GridData(1040);
        changeOrderGrid.widthHint = 30;
        changeOrderComposite.setLayoutData((Object)changeOrderGrid);
        changeOrderComposite.setSize(50, 200);
        changeOrderComposite.setLayout((Layout)new GridLayout(1, true));
        this.upOrderButton = new Button(changeOrderComposite, 4);
        this.upOrderButton.setLayoutData((Object)new GridData(1032));
        this.upOrderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WCTableEditComposite.this.upOrderButtonPushed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downOrderButton = new Button(changeOrderComposite, 4);
        this.downOrderButton.setAlignment(1024);
        this.downOrderButton.setLayoutData((Object)new GridData(1026));
        this.downOrderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WCTableEditComposite.this.downOrderButtonPushed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected abstract void initializeTableEditor();

    private void createEditButtonsCompsite(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(768));
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setLayoutData((Object)new GridData(640));
        this.addButton.setText("add");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WCTableEditComposite.this.addButtonPushed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.canModifyByDialog) {
            this.modifyButton = new Button(buttonsComposite, 8);
            this.modifyButton.setText("modify");
            this.modifyButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WCTableEditComposite.this.modifyButtonPushed(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.removeButton = new Button(buttonsComposite, 8);
        this.removeButton.setText("remove");
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WCTableEditComposite.this.removeButtonPushed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void updateButtonsStateChanged() {
        List elements = (List)this.getTableEditor().getElements();
        int[] indices = this.getTableViewer().getTable().getSelectionIndices();
        if (indices.length == 0) {
            this.getUpOrderButton().setEnabled(false);
            this.getDownOrderButton().setEnabled(false);
        } else {
            int top = indices[0];
            int bottom = indices[indices.length - 1];
            if (top == 0) {
                this.getUpOrderButton().setEnabled(false);
            } else {
                this.getUpOrderButton().setEnabled(true);
            }
            if (bottom == elements.size() - 1) {
                this.getDownOrderButton().setEnabled(false);
            } else {
                this.getDownOrderButton().setEnabled(true);
            }
        }
    }

    protected WCDocument getDocument() {
        return this.document;
    }

    protected abstract WCElementTableEditor getTableEditor();

    protected TableViewer getTableViewer() {
        return this.getTableEditor().getTableViewer();
    }

    public Button getDownOrderButton() {
        return this.downOrderButton;
    }

    public Button getUpOrderButton() {
        return this.upOrderButton;
    }

    protected void upOrderButtonPushed(SelectionEvent e) {
        TableItem[] items = this.getTableViewer().getTable().getSelection();
        int i = 0;
        while (i < items.length) {
            Object target = items[i].getData();
            this.moveUp(target);
            ++i;
        }
        this.getTableViewer().refresh();
        this.updateButtonsStateChanged();
    }

    protected void downOrderButtonPushed(SelectionEvent e) {
        TableItem[] items = this.getTableViewer().getTable().getSelection();
        int i = items.length - 1;
        while (i >= 0) {
            Object target = items[i].getData();
            this.moveDown(target);
            --i;
        }
        this.getTableViewer().refresh();
        this.updateButtonsStateChanged();
    }

    protected abstract void moveUp(Object var1);

    protected abstract void moveDown(Object var1);

    protected abstract void addButtonPushed(SelectionEvent var1);

    protected abstract void modifyButtonPushed(SelectionEvent var1);

    protected abstract void removeButtonPushed(SelectionEvent var1);

    protected void tableSelected(SelectionEvent e) {
        this.updateButtonsStateChanged();
    }
}

