/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.componentbuilder.util.ObjectCombo;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCDialog;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRandomNumberGeneratorCombo;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCIntValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCNumberValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValueFactory;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WCValueExpressionDialog
extends WCDialog {
    private WCValuedExpression value;
    private Button valueButton;
    private Button randomValueButton;
    private Button parameterButton;
    private ObjectCombo typeCombo;
    private ObjectCombo generatorCombo;
    private Text valueText;
    private Text minValueText;
    private Text maxValueText;
    private ParameterCombo parameterCombo;

    public WCValueExpressionDialog(Shell parentShell, WCDocument document, WCValuedExpression value) {
        super(parentShell, document);
        this.value = value;
        this.setDialogTitle("Value");
    }

    protected void initializeComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initializeTypeComposite(parent);
        this.initializeValueComposite(parent);
        parent.pack();
    }

    private void initializeTypeComposite(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayoutData((Object)new GridData(768));
        typeComposite.setLayout((Layout)new RowLayout(256));
        Label typeLabel = new Label(typeComposite, 0x1000000);
        typeLabel.setLayoutData((Object)new RowData(100, -1));
        typeLabel.setText("Type:");
        this.typeCombo = new ObjectCombo(typeComposite, 4);
        this.typeCombo.setLayoutData(new RowData(190, -1));
        this.typeCombo.addAll(Arrays.asList(WCValueFactory.getKeys()));
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.typeSelected(e);
            }
        });
        this.typeCombo.setData(this.value.getType());
        this.typeCombo.select(this.value.getType());
    }

    private void initializeValueComposite(Composite parent) {
        Composite valueComposite = new Composite(parent, 0);
        valueComposite.setLayoutData((Object)new GridData(1808));
        valueComposite.setLayout((Layout)new GridLayout(2, false));
        Label valueLabel = new Label(valueComposite, 0x1000000);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        valueLabel.setLayoutData((Object)gridData);
        valueLabel.setText("Value:");
        this.initializeInputValueComposite(valueComposite);
        this.initializeSpaceComposite(valueComposite);
        this.initializeInputRandomValueComposite(valueComposite);
        this.initializeSpaceComposite(valueComposite);
        this.initializeSelectParameterComposite(valueComposite);
        this.updateValueExpression();
    }

    private void initializeInputValueComposite(Composite valueComposite) {
        Composite composite = new Composite(valueComposite, 0);
        composite.setLayout((Layout)new RowLayout());
        this.valueButton = new Button(composite, 16);
        this.valueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.valueButtonSelected(e);
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setLayoutData((Object)new RowData(302, -1));
        valueLabel.setText("InputValue");
        this.valueText = new Text(composite, 2048);
        this.valueText.setLayoutData((Object)new RowData(140, -1));
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCValueExpressionDialog.this.valueTextChanged(e);
            }
        });
    }

    private void initializeInputRandomValueComposite(Composite valueComposite) {
        Composite composite = new Composite(valueComposite, 0);
        composite.setLayout((Layout)new RowLayout());
        this.randomValueButton = new Button(composite, 16);
        this.randomValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.randomValueButtonSelected(e);
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setLayoutData((Object)new RowData(150, -1));
        valueLabel.setText("Input Random Range");
        this.initializeRandomInputText(composite);
    }

    private void initializeRandomInputText(Composite valueComposite) {
        Composite editRandomComposite = new Composite(valueComposite, 0);
        editRandomComposite.setLayoutData((Object)new RowData(300, -1));
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editRandomComposite.setLayout((Layout)layout);
        Label minlabel = new Label(editRandomComposite, 131072);
        minlabel.setText("greater than or equal to");
        this.minValueText = new Text(editRandomComposite, 2048);
        this.minValueText.setLayoutData((Object)new GridData(768));
        this.minValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCValueExpressionDialog.this.minValueTextChanged(e);
            }
        });
        Label maxlabel = new Label(editRandomComposite, 131072);
        maxlabel.setText("less than");
        this.maxValueText = new Text(editRandomComposite, 2048);
        this.maxValueText.setLayoutData((Object)new GridData(768));
        this.maxValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCValueExpressionDialog.this.maxValueTextChanged(e);
            }
        });
        Label generatorLabel = new Label(editRandomComposite, 131072);
        generatorLabel.setText("generator:");
        this.generatorCombo = new WCRandomNumberGeneratorCombo(editRandomComposite, 12);
        this.generatorCombo.setLayoutData(new GridData(768));
        this.generatorCombo.setObjects(this.getDocument().getWorldTemplate().getRandomNumberGeneratorSettings());
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.generatorSelected(e);
            }
        });
    }

    private void initializeSelectParameterComposite(Composite valueComposite) {
        Composite composite = new Composite(valueComposite, 0);
        composite.setLayout((Layout)new RowLayout());
        this.parameterButton = new Button(composite, 16);
        this.parameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.parameterButtonSelected(e);
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setLayoutData((Object)new RowData(302, -1));
        valueLabel.setText("Select Parameter");
        this.parameterCombo = new ParameterCombo(composite, 12);
        this.parameterCombo.setLayoutData(new RowData(125, -1));
        this.parameterCombo.addAll(this.getValidParameters(this.value.getType()));
        this.parameterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCValueExpressionDialog.this.paramterSelected(e);
            }
        });
    }

    private void updateValueExpression() {
        if (this.value instanceof WCParameter) {
            this.parameterButton.setSelection(true);
            this.parameterCombo.select(this.value);
            this.parameterButtonSelected(null);
        } else if (this.value instanceof WCRandomNumberValue) {
            this.randomValueButton.setSelection(true);
            WCNumberValue min = ((WCRandomNumberValue)this.value).getMinimum();
            this.minValueText.setData((Object)min);
            this.minValueText.setText(min.getValueAsString());
            WCNumberValue max = ((WCRandomNumberValue)this.value).getMax();
            this.maxValueText.setData((Object)max);
            this.maxValueText.setText(max.getValueAsString());
            WCRandomNumberGeneratorSetting generator = ((WCRandomNumberValue)this.value).getGeneratorSetting();
            this.generatorCombo.select(generator);
            this.randomValueButtonSelected(null);
        } else if (this.value instanceof WCNumberValue) {
            this.valueButton.setSelection(true);
            this.valueText.setData((Object)this.value);
            this.valueText.setText(this.value.getValueAsString());
            this.valueButtonSelected(null);
        }
    }

    private List getValidParameters(String type) {
        List allParameters = this.getDocument().getWorldTemplate().getParameters();
        ArrayList<WCParameter> parameters = new ArrayList<WCParameter>();
        Iterator i = allParameters.iterator();
        while (i.hasNext()) {
            WCParameter parameter = (WCParameter)i.next();
            if (!parameter.getType().equals(type)) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private void initializeSpaceComposite(Composite valueComposite) {
        new Label(valueComposite, 0);
    }

    protected int getHeight() {
        return 250;
    }

    protected int getWidth() {
        return 600;
    }

    public WCValuedExpression getValue() {
        return this.value;
    }

    protected void okPressed() {
        this.updateValue();
        super.okPressed();
    }

    private void updateValue() {
        if (this.valueButton.getSelection()) {
            this.value = (WCValue)this.valueText.getData();
        } else if (this.randomValueButton.getSelection()) {
            WCNumberValue minValue = (WCNumberValue)this.minValueText.getData();
            WCNumberValue maxValue = (WCNumberValue)this.maxValueText.getData();
            WCRandomNumberGeneratorSetting setting = (WCRandomNumberGeneratorSetting)this.generatorCombo.getSelectionObject();
            this.value = new WCRandomNumberValue(maxValue, minValue, setting);
        } else if (this.parameterButton.getSelection()) {
            this.value = (WCParameter)this.parameterCombo.getData();
        }
    }

    protected void typeSelected(SelectionEvent e) {
        String currentType = (String)this.typeCombo.getSelectionObject();
        WCValue value = (WCValue)this.valueText.getData();
        WCValue minValue = (WCValue)this.minValueText.getData();
        WCValue maxValue = (WCValue)this.maxValueText.getData();
        WCParameter parameter = (WCParameter)this.parameterCombo.getData();
        if (value != null && !currentType.equals(value.getType())) {
            this.updateText(this.valueText, currentType);
        }
        if (minValue != null && !currentType.equals(minValue.getType())) {
            this.updateText(this.minValueText, currentType);
        }
        if (maxValue != null && !currentType.equals(maxValue.getType())) {
            this.updateText(this.maxValueText, currentType);
        }
        if (parameter != null && !currentType.equals(parameter.getType())) {
            this.parameterCombo.setObjects(this.getValidParameters(currentType));
            this.parameterCombo.setData(null);
        }
    }

    protected void valueTextChanged(ModifyEvent e) {
        String type = (String)this.typeCombo.getSelectionObject();
        this.updateText(this.valueText, type);
    }

    protected void minValueTextChanged(ModifyEvent e) {
        String type = (String)this.typeCombo.getSelectionObject();
        this.updateText(this.minValueText, type);
    }

    protected void maxValueTextChanged(ModifyEvent e) {
        String type = (String)this.typeCombo.getSelectionObject();
        this.updateText(this.maxValueText, type);
    }

    protected void paramterSelected(SelectionEvent e) {
        this.parameterCombo.setData(this.parameterCombo.getSelectionObject());
        this.stateChanged();
    }

    protected void valueButtonSelected(SelectionEvent e) {
        this.valueText.setEnabled(true);
        this.minValueText.setEnabled(false);
        this.maxValueText.setEnabled(false);
        this.generatorCombo.setEnabled(false);
        this.parameterCombo.setEnabled(false);
        this.randomValueButton.setSelection(false);
        this.parameterButton.setSelection(false);
        if (this.valueText.getData() != null) {
            this.stateChanged();
        }
    }

    protected void randomValueButtonSelected(SelectionEvent e) {
        this.valueText.setEnabled(false);
        this.minValueText.setEnabled(true);
        this.maxValueText.setEnabled(true);
        this.generatorCombo.setEnabled(true);
        this.parameterCombo.setEnabled(false);
        this.valueButton.setSelection(false);
        this.parameterButton.setSelection(false);
        if (this.minValueText.getData() != null && this.maxValueText.getData() != null) {
            this.stateChanged();
        }
    }

    protected void parameterButtonSelected(SelectionEvent e) {
        this.valueText.setEnabled(false);
        this.minValueText.setEnabled(false);
        this.maxValueText.setEnabled(false);
        this.generatorCombo.setEnabled(false);
        this.parameterCombo.setEnabled(true);
        this.randomValueButton.setSelection(false);
        this.valueButton.setSelection(false);
        if (this.parameterCombo.getData() != null) {
            this.stateChanged();
        }
    }

    private void updateText(Text text, String type) {
        WCValue value = WCValueFactory.createValue(type, text.getText());
        int selection = text.getCaretPosition();
        text.setData((Object)value);
        text.setSelection(selection);
        this.stateChanged();
    }

    protected void generatorSelected(SelectionEvent e) {
        this.stateChanged();
    }

    private boolean isValidValue() {
        this.updateValue();
        String type = (String)this.typeCombo.getSelectionObject();
        if (type.equals("int")) {
            ((WCIntValue)this.value).getValue();
            Integer.parseInt(this.valueText.getText());
        } else if (type.equals("double")) {
            double cfr_ignored_0 = ((WCIntValue)this.value).getValue();
            double cfr_ignored_1 = Integer.parseInt(this.valueText.getText());
        } else if (type.equals("long")) {
            ((WCIntValue)this.value).getValue();
            Integer.parseInt(this.valueText.getText());
        }
        return false;
    }

    class ParameterCombo
    extends ObjectCombo {
        public ParameterCombo(Composite parent, int style) {
            super(parent, style);
        }

        protected String representObject(Object o) {
            WCParameter parameter = (WCParameter)o;
            return parameter.getName();
        }
    }
}

