/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypedModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCSelfRelationPattern;

public class WCRelationGroup
extends WCTypedModel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    public static final String DEFAULT_NAME = "NewRelationGroup";
    private String name;
    private boolean isTwoWay = false;
    private WCRelationPattern pattern;
    private Set sourceAgentGroups = new HashSet();
    private Set targetAgentGroups = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public WCRelationGroup(String name, WCTypeModel type, WCDocument document, WCRelationPattern relationPattern, boolean isTwoWay) {
        super(type, document);
        this.name = name;
        this.pattern = relationPattern;
        this.isTwoWay = isTwoWay;
    }

    protected void addSourceAgentGroup(WCAgentGroup agentGroup) {
        this.sourceAgentGroups.add(agentGroup);
    }

    protected void removeSourceAgentGroup(WCAgentGroup agentGroup) {
        this.sourceAgentGroups.remove(agentGroup);
    }

    public void setSourceAgentGroups(List sourceAgents) {
        this.sourceAgentGroups.clear();
        this.sourceAgentGroups.addAll(sourceAgents);
    }

    protected void addTargetAgentGroup(WCAgentGroup agentGroup) {
        this.targetAgentGroups.add(agentGroup);
    }

    protected void removeTargetAgentGroup(WCAgentGroup agentGroup) {
        this.targetAgentGroups.remove(agentGroup);
    }

    public void setTargetAgentGroups(List targetAgents) {
        this.targetAgentGroups.clear();
        this.targetAgentGroups.addAll(targetAgents);
    }

    public WCRelationPattern getPattern() {
        return this.pattern;
    }

    public boolean isTwoWay() {
        return this.isTwoWay;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setPattern(WCRelationPattern pattern) {
        this.pattern = pattern;
    }

    protected void setTwoWay(boolean isTwoWay) {
        this.isTwoWay = isTwoWay;
    }

    public List getSourceAgentGroups() {
        return new ArrayList(this.sourceAgentGroups);
    }

    public List getTargetAgentGroups() {
        return new ArrayList(this.targetAgentGroups);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSourceAgentGroups().size());
        if (!(this.getPattern() instanceof WCSelfRelationPattern)) {
            String arrow = null;
            arrow = this.isTwoWay ? "<-" : "--";
            buf.append(String.valueOf(arrow) + "-->");
            buf.append(this.getTargetAgentGroups().size());
        }
        String typeName = this.getType().getTypeName();
        String relationName = typeName.substring(typeName.indexOf(95) + 1);
        buf.append("(" + relationName + ")");
        return buf.toString();
    }
}

