/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import org.boxed_economy.componentbuilder.worldcomposer.model.WCDoubleValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCIntValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCLongValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValue;

public class WCValueFactory {
    private static final String[] KEYS = new String[]{"int", "double", "long"};

    public static String[] getKeys() {
        return KEYS;
    }

    public static WCValue createValue(String type, String value) {
        try {
            if (type.equals("int")) {
                int intValue = Integer.parseInt(value);
                return new WCIntValue(intValue);
            }
            if (type.equals("long")) {
                long longValue = Long.parseLong(value);
                return new WCLongValue(longValue);
            }
            if (type.equals("double")) {
                double doubleValue = Double.parseDouble(value);
                return new WCDoubleValue(doubleValue);
            }
            throw new IllegalArgumentException("Invalid type. Creation value failed.");
        }
        catch (NumberFormatException numberFormatException) {
            return WCValueFactory.createValue(type, "0");
        }
    }
}

