/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model.xml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCBehaviorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCClockSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCGoodsSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCInformationSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCWorldTemplate;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCRandomRelationPattern;
import trier.util.EIdMap;

public class WCXMLOutput {
    private WCWorldTemplate world;
    private PrintStream out;
    private String encoding;
    private EIdMap idMap = new EIdMap();

    public WCXMLOutput(WCWorldTemplate world, OutputStream out, String encoding) {
        this.world = world;
        this.out = new PrintStream(out);
        this.encoding = encoding;
    }

    public void writeXml() {
        this.writeHeader();
        this.writeWorld();
    }

    private void writeHeader() {
        this.out.println("<?xml version='1.0' encoding='" + this.encoding + "' ?>");
    }

    private void writeWorld() {
        this.out.println("<world id='" + this.idMap.putObject((Object)this.world) + "'>");
        this.writeName();
        this.writeDescription();
        this.writeClock();
        this.writeRandomNumberGenerators();
        this.writeParameters();
        this.writeAgentGroups();
        this.writeRelationGroups();
        this.out.println("</world>");
    }

    private void writeName() {
        this.writeChild("name", this.world.getName());
    }

    private void writeDescription() {
        this.writeChild("description", this.world.getDescription());
    }

    private void writeClock() {
        WCClockSetting clock = this.world.getClockSetting();
        this.out.println("<clock id='" + this.idMap.putObject((Object)clock) + "'>");
        this.writeChild("package", clock.getClockPackage());
        this.writeChild("class", clock.getName());
        this.out.println("</clock>");
    }

    private void writeRandomNumberGenerators() {
        this.out.println("<generators>");
        Iterator i = this.world.getRandomNumberGeneratorSettings().iterator();
        while (i.hasNext()) {
            WCRandomNumberGeneratorSetting generator = (WCRandomNumberGeneratorSetting)i.next();
            this.writeRandomNumberGenerator(generator);
        }
        this.out.println("</generators>");
    }

    private void writeRandomNumberGenerator(WCRandomNumberGeneratorSetting generator) {
        this.out.println("<generator id='" + this.idMap.putObject((Object)generator) + "'>");
        this.writeChild("package", generator.getPackagename());
        this.writeChild("class", generator.getClassName());
        this.writeChild("name", generator.getName());
        this.writeChild("seed", generator.getSeed().getValueAsString());
        this.out.println("</generator>");
    }

    private void writeParameters() {
        this.out.println("<parameters>");
        Iterator i = this.world.getParameters().iterator();
        while (i.hasNext()) {
            WCParameter parameter = (WCParameter)i.next();
            this.writeParameter(parameter);
        }
        this.out.println("</parameters>");
    }

    private void writeParameter(WCParameter parameter) {
        this.out.println("<parameter id='" + this.idMap.putObject((Object)parameter) + "'>");
        this.writeChild("name", parameter.getName());
        this.writeChild("description", parameter.getDescription());
        this.writeChild("type", parameter.getType());
        this.writeValue(parameter.getValue());
        this.out.println("</parameter>");
    }

    private void writeAgentGroups() {
        this.out.println("<agentgroups>");
        Iterator i = this.world.getAgentGroups().iterator();
        while (i.hasNext()) {
            WCAgentGroup agentGroup = (WCAgentGroup)i.next();
            this.writeAgentGroup(agentGroup);
        }
        this.out.println("</agentgroups>");
    }

    private void writeAgentGroup(WCAgentGroup agentGroup) {
        this.out.println("<agentgroup id='" + this.idMap.putObject((Object)agentGroup) + "'>");
        this.writeChild("name", agentGroup.getName());
        this.writeType(agentGroup.getType());
        this.out.println("<number>");
        this.writeValue(agentGroup.getNumber());
        this.out.println("</number>");
        this.out.println("<behaviorsettings>");
        Iterator i = agentGroup.getBehaviorSettings().iterator();
        while (i.hasNext()) {
            WCBehaviorSetting behaviorSetting = (WCBehaviorSetting)i.next();
            this.writeBehavior(behaviorSetting);
        }
        this.out.println("</behaviorsettings>");
        this.out.println("<goodssettings>");
        Iterator j = agentGroup.getGoodsSettings().iterator();
        while (j.hasNext()) {
            WCGoodsSetting goodsSetting = (WCGoodsSetting)j.next();
            this.writeGoods(goodsSetting);
        }
        this.out.println("</goodssettings>");
        this.out.println("<informationsettings>");
        Iterator k = agentGroup.getInformationSettings().iterator();
        while (k.hasNext()) {
            WCInformationSetting informationSetting = (WCInformationSetting)k.next();
            this.writeInformation(informationSetting);
        }
        this.out.println("</informationsettings>");
        this.out.println("</agentgroup>");
    }

    private void writeBehavior(WCBehaviorSetting behaviorSetting) {
        this.out.println("<behaviorsetting id='" + this.idMap.putObject((Object)behaviorSetting) + "'>");
        this.writeType(behaviorSetting.getType());
        this.out.println("</behaviorsetting>");
    }

    private void writeGoods(WCGoodsSetting goodsSetting) {
        this.out.println("<goodssetting id='" + this.idMap.putObject((Object)goodsSetting) + "'>");
        this.writeType(goodsSetting.getType());
        this.out.println("<quantity>");
        this.writeValue(goodsSetting.getQuantity());
        this.out.println("</quantity>");
        this.out.println("</goodssetting>");
    }

    private void writeInformation(WCInformationSetting informationSetting) {
        this.out.println("<informationsetting id='" + this.idMap.putObject((Object)informationSetting) + "'>");
        this.writeType(informationSetting.getType());
        this.out.println("<impl>");
        this.writeChild("package", informationSetting.getPackagename());
        this.writeChild("class", informationSetting.getClassName());
        this.out.println("</impl>");
        this.out.println("</informationsetting>");
    }

    private void writeRelationGroups() {
        this.out.println("<relationgroups>");
        Iterator i = this.world.getRelationGroups().iterator();
        while (i.hasNext()) {
            WCRelationGroup relationGroup = (WCRelationGroup)i.next();
            this.writeRelationGroup(relationGroup);
        }
        this.out.println("</relationgroups>");
    }

    private void writeRelationGroup(WCRelationGroup relationGroup) {
        this.out.println("<relationgroup id='" + this.idMap.putObject((Object)relationGroup) + "'>");
        this.writeChild("name", relationGroup.getName());
        this.writeType(relationGroup.getType());
        this.writeChild("twoway", String.valueOf(relationGroup.isTwoWay()));
        this.writeRelationPattern(relationGroup.getPattern());
        this.out.println("<source>");
        Iterator i = relationGroup.getSourceAgentGroups().iterator();
        while (i.hasNext()) {
            WCAgentGroup agentGroup = (WCAgentGroup)i.next();
            this.writeChild("refagent", this.idMap.getId((Object)agentGroup));
        }
        this.out.println("</source>");
        this.out.println("<target>");
        Iterator j = relationGroup.getSourceAgentGroups().iterator();
        while (j.hasNext()) {
            WCAgentGroup agentGroup = (WCAgentGroup)j.next();
            this.writeChild("refagent", this.idMap.getId((Object)agentGroup));
        }
        this.out.println("</target>");
        this.out.println("</relationgroup>");
    }

    private void writeRelationPattern(WCRelationPattern pattern) {
        this.out.println("<pattern id='" + this.idMap.putObject((Object)pattern) + "' class='" + pattern.getClass().getName() + "'>");
        if (pattern instanceof WCRandomRelationPattern) {
            WCRandomRelationPattern random = (WCRandomRelationPattern)pattern;
            this.writeChild("number", String.valueOf(random.getNumberOfRelation()));
            this.writeChild("refgenerator", this.idMap.getId((Object)random.getGeneratorSetting()));
        }
        this.out.println("</pattern>");
    }

    private void writeValue(WCValuedExpression expression) {
        this.out.println("<value id='" + this.idMap.putObject((Object)expression) + "' class='" + expression.getClass().getName() + "'>");
        if (expression instanceof WCRandomNumberValue) {
            WCRandomNumberValue random = (WCRandomNumberValue)expression;
            this.writeChild("refgenerator", this.idMap.getId((Object)random.getGeneratorSetting()));
            this.out.println("<max>");
            this.writeValue(random.getMax());
            this.out.println("</max>");
            this.out.println("<minimum>");
            this.writeValue(random.getMinimum());
            this.out.println("</minimum>");
        } else if (expression instanceof WCParameter) {
            this.writeChild("refparameter", this.idMap.getId((Object)expression));
        } else {
            this.writeChild("type", expression.getType());
            this.writeChild("value", expression.getValueAsString());
        }
        this.out.println("</value>");
    }

    private void writeType(WCTypeModel model) {
        this.out.println("<type id='" + this.idMap.putObject((Object)model) + "'>");
        this.writeChild("modelname", model.getModelName());
        this.writeChild("modelpackage", model.getModelPackage());
        this.writeChild("typename", model.getTypeName());
        this.out.println("</type>");
    }

    private void writeChild(String name, String value) {
        this.out.println("<" + name + ">");
        this.out.println(value);
        this.out.println("</" + name + ">");
    }
}

