/*
 * Decompiled with CFR 0.152.
 */
package sdeditor;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDDocument;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDProject;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDRootStateMachine;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTransition;
import sdeditor.model.SDTransitionLabel;

public class SDEditDomain
extends DefaultEditDomain {
    private SDDocument document = null;
    private SDProject project = null;

    public SDEditDomain(IEditorPart editorPart) {
        super(editorPart);
    }

    public SDProject getProject() {
        return this.project;
    }

    public void setProject(SDProject project) {
        this.project = project;
    }

    public SDDocument getDocument() {
        return this.document;
    }

    public void setDocument(SDDocument document) {
        this.document = document;
    }

    public SDRootStateMachine getRootStateMachine() {
        return this.document.getRootStateMachine();
    }

    public Command AddStateToStateMachineCommand(SDStateMachine parent, SDState state) {
        return new AddStateToStateMachineCommand(parent, state);
    }

    public Command RemoveOrphanStateFromStateMachineCommand(SDStateMachine parent, SDState state) {
        return new RemoveOrphanStateFromStateMachineCommand(parent, state);
    }

    public Command RemoveStateFromStateMachineCommand(SDStateMachine parent, SDState state) {
        return new RemoveStateFromStateMachineCommand(parent, state);
    }

    public Command SetBoundsToStateCommand(SDState state, Rectangle bounds) {
        return new SetBoundsToStateCommand(state, bounds);
    }

    public Command SetNameToStateCommand(SDCompositeState state, String name) {
        return new SetNameToStateCommand(state, name);
    }

    public Command AddActionToStateCommand(SDCompositeState state, SDAction action, int where) {
        return new AddActionToStateCommand(state, action, where);
    }

    public Command RemoveActionFromStateCommand(SDCompositeState state, int index, int where) {
        return new RemoveActionFromStateCommand(state, index, where);
    }

    public Command MoveActionInStateCommand(SDCompositeState state, int where, int index, int move) {
        return new MoveActionInStateCommand(state, where, index, move);
    }

    public Command AddTransitionCommand(SDTransition transition, SDState source, SDState target) {
        return new AddTransitionCommand(transition, source, target);
    }

    public Command RemoveTransitionCommand(SDTransition transition) {
        return new RemoveTransitionCommand(transition);
    }

    public Command ReconnectTransitionCommand(SDTransition transition, SDState source, SDState target) {
        return new ReconnectTransitionCommand(transition, source, target);
    }

    public Command SetEventToTransitionCommand(SDTransition transition, SDEvent event) {
        return new SetEventToTransitionCommand(transition, event);
    }

    public Command SetGuardConditionToTransitionCommand(SDTransition transition, SDGuardCondition guard) {
        return new SetGuardConditionToTransitionCommand(transition, guard);
    }

    public Command AddActionToTransitionCommand(SDTransition transition, SDAction action) {
        return new AddActionToTransitionCommand(transition, action);
    }

    public Command RemoveActionFromTransitionCommand(SDTransition transition, int index) {
        return new RemoveActionFromTransitionCommand(transition, index);
    }

    public Command MoveActionInTransitionCommand(SDTransition transition, int index, int move) {
        return new MoveActionInTransitionCommand(transition, index, move);
    }

    public Command AddBendpointToTransitionCommand(SDTransition transition, SDRelativePoint point, int index) {
        return new AddBendpointToTransitionCommand(transition, point, index);
    }

    public Command RemoveBendpointFromTransitionCommand(SDTransition transition, int index) {
        return new RemoveBendpointFromTransitionCommand(transition, index);
    }

    public Command MoveBendpointInTransitionCommand(SDTransition transition, SDRelativePoint point, int index) {
        return new MoveBendpointInTransitionCommand(transition, point, index);
    }

    public Command MoveTransitionLabelCommand(SDTransitionLabel label, SDRelativePoint point) {
        return new MoveTransitionLabelCommand(label, point);
    }

    public class AddStateToStateMachineCommand
    extends Command {
        private SDStateMachine parent;
        private SDState state;

        AddStateToStateMachineCommand(SDStateMachine parent, SDState state) {
            this.parent = parent;
            this.state = state;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.addStateToStateMachine(this.parent, this.state);
        }

        public void undo() {
            SDEditDomain.this.document.removeOrphanStateFromStateMachine(this.parent, this.state);
        }

        public String getLabel() {
            return "AddStateToStateMachineCommand:" + this.parent + ":" + this.state.getName();
        }
    }

    class RemoveOrphanStateFromStateMachineCommand
    extends Command {
        private SDStateMachine parent;
        private SDState state;

        RemoveOrphanStateFromStateMachineCommand(SDStateMachine parent, SDState state) {
            this.parent = parent;
            this.state = state;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.removeOrphanStateFromStateMachine(this.parent, this.state);
        }

        public void undo() {
            SDEditDomain.this.document.addStateToStateMachine(this.parent, this.state);
        }

        public String getLabel() {
            return "RemoveOrphanStateFromStateMachineCommand:" + this.parent + ":" + this.state.getName();
        }
    }

    class RemoveStateFromStateMachineCommand
    extends Command {
        private SDStateMachine parent;
        private SDState state;
        private List transitions;

        RemoveStateFromStateMachineCommand(SDStateMachine parent, SDState state) {
            this.parent = parent;
            this.state = state;
        }

        public void execute() {
            this.transitions = SDEditDomain.this.document.removeStateFromStateMachine(this.parent, this.state);
        }

        public void redo() {
            SDEditDomain.this.document.removeStateFromStateMachine(this.parent, this.state);
        }

        public void undo() {
            SDEditDomain.this.document.addStateToStateMachine(this.parent, this.state, this.transitions);
        }

        public String getLabel() {
            return "RemoveStateFromStateMachineCommand:" + this.parent + ":" + this.state.getName();
        }
    }

    class SetBoundsToStateCommand
    extends Command {
        private SDState state;
        private Rectangle bounds;
        private Rectangle oldBounds;

        SetBoundsToStateCommand(SDState state, Rectangle bounds) {
            this.state = state;
            this.bounds = bounds;
        }

        public void execute() {
            this.oldBounds = this.state.getBounds();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.setBoundsToState(this.state, this.bounds);
        }

        public void undo() {
            SDEditDomain.this.document.setBoundsToState(this.state, this.oldBounds);
        }

        public String getLabel() {
            return "SetBoundsToStateCommand:" + this.state.getName() + ":" + this.bounds;
        }
    }

    class SetNameToStateCommand
    extends Command {
        private SDCompositeState state;
        private String name;
        private String oldName;

        SetNameToStateCommand(SDCompositeState state, String name) {
            this.state = state;
            this.name = name;
        }

        public void execute() {
            this.oldName = this.state.getName();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.setNameToState(this.state, this.name);
        }

        public void undo() {
            SDEditDomain.this.document.setNameToState(this.state, this.oldName);
        }

        public String getLabel() {
            return "SetNameToStateCommand:" + this.state.getName() + ":" + this.name;
        }
    }

    class AddActionToStateCommand
    extends Command {
        private SDCompositeState state;
        private SDAction action;
        private int where;
        private int addedIndex;

        AddActionToStateCommand(SDCompositeState state, SDAction action, int where) {
            this.state = state;
            this.action = action;
            this.where = where;
        }

        public void execute() {
            this.addedIndex = SDEditDomain.this.document.getActionsFromState(this.state, this.where).size();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.addActionToState(this.state, this.where, this.action);
        }

        public void undo() {
            SDEditDomain.this.document.removeActionFromState(this.state, this.where, this.addedIndex);
        }

        public String getLabel() {
            return "AddActionToStateCommand:" + this.state.getName() + ":" + this.action + ":" + this.where;
        }
    }

    class RemoveActionFromStateCommand
    extends Command {
        private SDCompositeState state;
        private int index;
        private int where;
        private SDAction removedAction;

        RemoveActionFromStateCommand(SDCompositeState state, int index, int where) {
            this.state = state;
            this.index = index;
            this.where = where;
        }

        public void execute() {
            this.removedAction = (SDAction)SDEditDomain.this.document.getActionsFromState(this.state, this.where).get(this.index);
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.removeActionFromState(this.state, this.where, this.index);
        }

        public void undo() {
            SDEditDomain.this.document.addActionToState(this.state, this.where, this.removedAction, this.index);
        }

        public String getLabel() {
            return "RemoveActionFromStateCommand:" + this.state.getName() + ":" + this.removedAction + ":" + this.where;
        }
    }

    class MoveActionInStateCommand
    extends Command {
        private SDCompositeState state;
        private int index;
        private int where;
        private int move;

        MoveActionInStateCommand(SDCompositeState state, int where, int index, int move) {
            this.state = state;
            this.where = where;
            this.index = index;
            this.move = move;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.moveActionInState(this.state, this.where, this.index, this.move);
        }

        public void undo() {
            SDEditDomain.this.document.moveActionInState(this.state, this.where, this.index + this.move, -this.move);
        }

        public String getLabel() {
            return "MoveActionInStateCommand:" + this.state.getName() + ":" + this.where + ":" + this.index + ":" + this.move;
        }
    }

    class AddTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDState source;
        private SDState target;

        AddTransitionCommand(SDTransition transition, SDState source, SDState target) {
            this.transition = transition;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            SDEditDomain.this.document.setStateToTransition(this.transition, this.source, this.target);
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.addTransition(this.transition);
        }

        public void undo() {
            SDEditDomain.this.document.removeTransition(this.transition);
        }

        public String getLabel() {
            return "AddTransitionCommand:" + this.source + ":" + this.target;
        }
    }

    class RemoveTransitionCommand
    extends Command {
        private SDTransition transition;

        RemoveTransitionCommand(SDTransition transition) {
            this.transition = transition;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.removeTransition(this.transition);
        }

        public void undo() {
            SDEditDomain.this.document.addTransition(this.transition);
        }

        public String getLabel() {
            return "RemoveTransitionCommand:" + this.transition;
        }
    }

    class ReconnectTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDState source;
        private SDState target;
        private SDState oldSource;
        private SDState oldTarget;

        ReconnectTransitionCommand(SDTransition transition, SDState source, SDState target) {
            this.transition = transition;
            this.source = source;
            this.target = target;
        }

        public void execute() {
            this.oldSource = this.transition.getSourceState();
            this.oldTarget = this.transition.getTargetState();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.reconnectTransition(this.transition, this.source, this.target);
        }

        public void undo() {
            SDEditDomain.this.document.reconnectTransition(this.transition, this.oldSource, this.oldTarget);
        }

        public String getLabel() {
            return "ReconnectTransitionCommand:" + this.transition + ":" + this.source + ":" + this.target;
        }
    }

    class SetEventToTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDEvent event;
        private SDEvent oldEvent;

        SetEventToTransitionCommand(SDTransition transition, SDEvent event) {
            this.transition = transition;
            this.event = event;
        }

        public void execute() {
            this.oldEvent = this.transition.getEvent();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.setEventToTransition(this.transition, this.event);
        }

        public void undo() {
            SDEditDomain.this.document.setEventToTransition(this.transition, this.oldEvent);
        }

        public String getLabel() {
            return "SetEventToTransitionCommand:" + this.transition + ":" + this.event;
        }
    }

    class SetGuardConditionToTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDGuardCondition guard;
        private SDGuardCondition oldGuard;

        SetGuardConditionToTransitionCommand(SDTransition transition, SDGuardCondition guard) {
            this.transition = transition;
            this.guard = guard;
        }

        public void execute() {
            this.oldGuard = this.transition.getGuardCondition();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.setGuardConditionToTransition(this.transition, this.guard);
        }

        public void undo() {
            SDEditDomain.this.document.setGuardConditionToTransition(this.transition, this.oldGuard);
        }

        public String getLabel() {
            return "SetGuardConditionToTransitionCommand:" + this.transition + ":" + this.guard;
        }
    }

    class AddActionToTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDAction action;

        AddActionToTransitionCommand(SDTransition transition, SDAction action) {
            this.transition = transition;
            this.action = action;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.addActionToTransition(this.transition, this.action);
        }

        public void undo() {
            int lastObjectIndex = this.transition.getActions().size();
            SDEditDomain.this.document.removeActionFromTransition(this.transition, lastObjectIndex);
        }

        public String getLabel() {
            return "AddActionToTransitionCommand:" + this.transition + ":" + this.action;
        }
    }

    class RemoveActionFromTransitionCommand
    extends Command {
        private SDTransition transition;
        private int index;
        private SDAction removedAction;

        RemoveActionFromTransitionCommand(SDTransition transition, int index) {
            this.transition = transition;
            this.index = index;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            this.removedAction = SDEditDomain.this.document.removeActionFromTransition(this.transition, this.index);
        }

        public void undo() {
            SDEditDomain.this.document.addActionToTransition(this.transition, this.removedAction, this.index);
        }

        public String getLabel() {
            return "RemoveActionFromTransitionCommand:" + this.removedAction + ":" + this.index;
        }
    }

    class MoveActionInTransitionCommand
    extends Command {
        private SDTransition transition;
        private int index;
        private int move;

        MoveActionInTransitionCommand(SDTransition transition, int index, int move) {
            this.transition = transition;
            this.index = index;
            this.move = move;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.moveActionInTransition(this.transition, this.index, this.move);
        }

        public void undo() {
            SDEditDomain.this.document.moveActionInTransition(this.transition, this.index + this.move, -this.move);
        }

        public String getLabel() {
            return "MoveActionInTransitionCommand:" + this.transition + ":" + this.index + ":" + this.move;
        }
    }

    class AddBendpointToTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDRelativePoint point;
        private int index;

        AddBendpointToTransitionCommand(SDTransition transition, SDRelativePoint point, int index) {
            this.transition = transition;
            this.point = point;
            this.index = index;
        }

        public void execute() {
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.addBendpointToTransition(this.transition, this.point, this.index);
        }

        public void undo() {
            SDEditDomain.this.document.removeBendpointFromTransition(this.transition, this.index);
        }

        public String getLabel() {
            return "AddBendpointToTransitionCommand:" + this.transition + ":" + this.index + ":" + this.point;
        }
    }

    class RemoveBendpointFromTransitionCommand
    extends Command {
        private SDTransition transition;
        private int index;
        private SDRelativePoint removedPoint;

        RemoveBendpointFromTransitionCommand(SDTransition transition, int index) {
            this.transition = transition;
            this.index = index;
        }

        public void execute() {
            this.removedPoint = (SDRelativePoint)this.transition.getBendpoints().get(this.index);
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.removeBendpointFromTransition(this.transition, this.index);
        }

        public void undo() {
            SDEditDomain.this.document.addBendpointToTransition(this.transition, this.removedPoint, this.index);
        }

        public String getLabel() {
            return "RemoveBendpointFromTransitionCommand:" + this.transition + ":" + this.index + ":" + this.removedPoint;
        }
    }

    class MoveBendpointInTransitionCommand
    extends Command {
        private SDTransition transition;
        private SDRelativePoint point;
        private int index;
        private SDRelativePoint oldPoint;

        MoveBendpointInTransitionCommand(SDTransition transition, SDRelativePoint point, int index) {
            this.transition = transition;
            this.point = point;
            this.index = index;
        }

        public void execute() {
            this.oldPoint = (SDRelativePoint)this.transition.getBendpoints().get(this.index);
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.moveBendpointInTransition(this.transition, this.index, this.point);
        }

        public void undo() {
            SDEditDomain.this.document.moveBendpointInTransition(this.transition, this.index, this.oldPoint);
        }

        public String getLabel() {
            return "MoveBendpointInTransitionCommand:" + this.transition + ":" + this.index + ":" + this.point;
        }
    }

    class MoveTransitionLabelCommand
    extends Command {
        private SDTransitionLabel label;
        private SDRelativePoint point;
        private SDRelativePoint oldPoint;

        MoveTransitionLabelCommand(SDTransitionLabel label, SDRelativePoint point) {
            this.label = label;
            this.point = point;
        }

        public void execute() {
            this.oldPoint = this.label.getLocation();
            this.redo();
        }

        public void redo() {
            SDEditDomain.this.document.setLocationToTransitionLabel(this.label, this.point);
        }

        public void undo() {
            SDEditDomain.this.document.setLocationToTransitionLabel(this.label, this.oldPoint);
        }

        public String getLabel() {
            return "MoveTransitionLabelCommand:" + this.point;
        }
    }
}

