/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.codegen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchSite;
import sdeditor.codegen.SDCodeGenerationEnvironment;
import trier.TrierPlugin;

public class SDCodeGenerationUtil {
    private SDCodeGenerationUtil() {
    }

    public static String format(String contents, ICompilationUnit compilationUnit) throws JavaModelException {
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)compilationUnit);
        int indentDepth = StubUtility.getIndentUsed((IJavaElement)compilationUnit);
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(null);
        return formatter.format(contents, indentDepth, null, lineDelim);
    }

    public static void organizeImport(ICompilationUnit compilationUnit) throws JavaModelException {
        OrganizeImportsAction action = new OrganizeImportsAction((IWorkbenchSite)TrierPlugin.getDefault().getActivePage().getActiveEditor().getSite());
        action.run(compilationUnit);
    }

    public static String trimExtension(IFile file) {
        String before = file.getName();
        String after = before.substring(0, before.indexOf(file.getFileExtension()) - 1);
        return after;
    }

    public static IType createType(String name, String superClass, List interfaces, SDCodeGenerationEnvironment env, IProgressMonitor monitor) throws Exception {
        SimpleNewClassWizardPage newClassPage = new SimpleNewClassWizardPage();
        newClassPage.setPackageFragmentRoot(env.getPackageRoot(), false);
        newClassPage.setPackageFragment(env.getPackage(), false);
        newClassPage.setTypeName(name, false);
        newClassPage.setSuperClass(superClass, false);
        newClassPage.setSuperInterfaces(interfaces, false);
        newClassPage.setMethodStubSelection(false, false, false, false);
        IRunnableWithProgress runnable = newClassPage.getRunnable();
        runnable.run(monitor);
        IType original = (IType)JavaModelUtil.toOriginal((IMember)newClassPage.getCreatedType());
        return original;
    }

    public static void overrideAllMethod(IType type, IProgressMonitor monitor) throws Exception {
        SDCodeGenerationUtil.overrideMethod(type, new AllOverrideMethodQuery(), monitor);
    }

    public static void overrideMethodForSpecialType(IType type, IType specialType, IProgressMonitor monitor) throws Exception {
        SDCodeGenerationUtil.overrideMethod(type, new OverrideMethodQueryForSpecialType(specialType), monitor);
    }

    public static void overrideMethod(IType type, IOverrideMethodQuery query, IProgressMonitor monitor) throws Exception {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        AddUnimplementedMethodsOperation op = new AddUnimplementedMethodsOperation(type, settings, query, true);
        op.run(monitor);
    }

    private static class SimpleNewClassWizardPage
    extends NewClassWizardPage {
        SimpleNewClassWizardPage() {
        }

        protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    static class AllOverrideMethodQuery
    implements IOverrideMethodQuery {
        AllOverrideMethodQuery() {
        }

        public IMethod[] select(IMethod[] elements, IMethod[] defaultSelected, ITypeHierarchy typeHierarchy) {
            return defaultSelected;
        }
    }

    static class OverrideMethodQueryForSpecialType
    implements IOverrideMethodQuery {
        private IType specialType = null;

        public OverrideMethodQueryForSpecialType(IType specialType) {
            this.specialType = specialType;
        }

        public IMethod[] select(IMethod[] elements, IMethod[] defaultSelected, ITypeHierarchy typeHierarchy) {
            ArrayList<IMethod> list = new ArrayList<IMethod>();
            int i = 0;
            while (i < defaultSelected.length) {
                if (defaultSelected[i].getDeclaringType().equals(this.specialType)) {
                    list.add(defaultSelected[i]);
                }
                ++i;
            }
            return list.toArray(new IMethod[list.size()]);
        }
    }
}

