/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;
import sdeditor.editpart.SDStateLabelDirectEditer;
import sdeditor.figure.SDStateFigure;
import sdeditor.util.DirectEditer;

public class SDStateLabelDirectEditer
extends DirectEditer {
    public SDStateLabelDirectEditer(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    protected void initCellEditor() {
        String initialLabelText = this.getLabel().getText();
        this.getCellEditor().setValue((Object)initialLabelText);
        Text text = (Text)this.getCellEditor().getControl();
        text.setFont(this.getLabel().getFont());
        text.selectAll();
    }

    private Label getLabel() {
        return ((SDStateFigure)this.getEditPart().getFigure()).getTitleLabel();
    }

    public static final CellEditorLocator createLocator(Label label) {
        class LabelCellEditorLocator
        implements CellEditorLocator {
            private Label label;

            public LabelCellEditorLocator(Label label) {
                this.label = label;
            }

            public void relocate(CellEditor celleditor) {
                Text text = (Text)celleditor.getControl();
                Point sel = text.getSelection();
                Point pref = text.computeSize(-1, -1);
                Rectangle rect = this.label.getTextBounds().getCopy();
                this.label.translateToAbsolute((Translatable)rect);
                text.setBounds(rect.x, rect.y, pref.x, pref.y);
                text.setSelection(0);
                text.setSelection(sel);
            }
        }
        return new LabelCellEditorLocator(label);
    }
}

