/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import sdeditor.model.SDRelativePoint;

public class SDTransitionLabelLocator
implements Locator {
    private Connection connection;
    private SDRelativePoint rp;

    public SDTransitionLabelLocator(Connection connection, SDRelativePoint rp) {
        this.connection = connection;
        this.rp = rp;
    }

    public void relocate(IFigure target) {
        target.setSize(target.getPreferredSize());
        target.setLocation(this.calcLocation());
    }

    private Point calcLocation() {
        Point source = SDTransitionLabelLocator.getSourcePoint(this.connection);
        Point target = SDTransitionLabelLocator.getTargetPoint(this.connection);
        Point p = new Point();
        float weight = this.rp.getWeight();
        p.x = (int)((float)(source.x + this.rp.getD1().width) * (1.0f - weight) + weight * (float)(target.x + this.rp.getD2().width));
        p.y = (int)((float)(source.y + this.rp.getD1().height) * (1.0f - weight) + weight * (float)(target.y + this.rp.getD2().height));
        this.connection.translateToRelative((Translatable)p);
        return p;
    }

    public static Point getSourcePoint(Connection c) {
        PointList list = c.getPoints();
        Point p = list.getFirstPoint();
        c.translateToAbsolute((Translatable)p);
        return p;
    }

    public static Point getTargetPoint(Connection c) {
        PointList list = c.getPoints();
        Point p = list.getLastPoint();
        c.translateToAbsolute((Translatable)p);
        return p;
    }
}

