/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.policy;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Color;
import sdeditor.editpart.SDTransitionLabelEditPart;

public class SDStateHighlightEditPolicy
extends GraphicalEditPolicy {
    private Border highlighter = new HighlightBorder(ColorConstants.darkBlue, 3);
    private Border revert;
    private boolean isHighlight = false;

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("move") || request.getType().equals("connection start") || request.getType().equals("connection end") || request.getType().equals("create child")) {
            this.setHighlight(true);
        } else if (request.getType().equals("add children")) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
            if (this.isLabels(cbr.getEditParts())) {
                return;
            }
            this.setHighlight(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.setHighlight(false);
    }

    private void setHighlight(boolean highlight) {
        if (!this.isHighlight && highlight) {
            this.showHighlight();
            this.isHighlight = true;
        }
        if (this.isHighlight && !highlight) {
            this.eraseHighlight();
            this.isHighlight = false;
        }
    }

    private void showHighlight() {
        this.revert = this.getContainerFigure().getBorder();
        this.getContainerFigure().setBorder(this.highlighter);
        this.getContainerFigure().repaint();
    }

    private void eraseHighlight() {
        this.getContainerFigure().setBorder(this.revert);
        this.getContainerFigure().repaint();
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    private boolean isLabels(List editparts) {
        Iterator i = editparts.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof SDTransitionLabelEditPart) continue;
            return false;
        }
        return true;
    }

    class HighlightBorder
    extends LineBorder {
        HighlightBorder(Color c, int width) {
            super(c, width);
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0);
        }
    }
}

