/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.propertyedit;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sdeditor.SDEditDomain;
import sdeditor.editpart.propertyedit.SDAvaliableActionListComposite;
import sdeditor.editpart.propertyedit.SDDialogProperties;
import sdeditor.model.SDAction;
import sdeditor.util.ObjectList;

public abstract class SDActionListComposite
extends Composite {
    private SDEditDomain domain;
    private CompoundCommand actionCommands = new CompoundCommand();
    private SDAvaliableActionListComposite availableActions;
    private ObjectList actionList;
    private Button buttonUp;
    private Button buttonDown;
    private Button buttonRemove;
    private Button buttonAdd;
    private Label label;

    public SDActionListComposite(Composite parent, int style, List actions, SDEditDomain domain) {
        super(parent, style);
        this.domain = domain;
        this.init(actions);
    }

    private void init(List actions) {
        RowLayout layout = new RowLayout(512);
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        Composite cMain = new Composite((Composite)this, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.pack = false;
        cMain.setLayout((Layout)rowLayout);
        Composite cLeft = new Composite(cMain, 2048);
        cLeft.setLayout((Layout)SDDialogProperties.createNonMarginGridLayout(2, false));
        this.actionList = new ObjectList(cLeft, 258);
        this.actionList.setObjects(actions);
        this.actionList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDActionListComposite.this.selectActionList(e);
            }
        });
        this.setActionListSize(120, 100);
        Composite cUpDownButtons = new Composite(cLeft, 0);
        cUpDownButtons.setLayoutData((Object)new GridData(1040));
        cUpDownButtons.setLayout((Layout)new FillLayout(512));
        this.buttonUp = new Button(cUpDownButtons, 0);
        this.buttonUp.setEnabled(false);
        this.buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDActionListComposite.this.pushUpButton(e);
            }
        });
        this.buttonUp.setText("Up");
        this.buttonDown = new Button(cUpDownButtons, 0);
        this.buttonDown.setEnabled(false);
        this.buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDActionListComposite.this.pushDownButton(e);
            }
        });
        this.buttonDown.setText("Dn");
        Composite cRight = new Composite(cMain, 0);
        cRight.setLayout((Layout)new GridLayout());
        this.buttonAdd = new Button(cRight, 0);
        this.buttonAdd.setText("<=Add");
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setLayoutData((Object)SDDialogProperties.createCenteringGridData(3));
        this.buttonRemove = new Button(cRight, 0);
        this.buttonRemove.setText("Remove=>");
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.setLayoutData((Object)SDDialogProperties.createCenteringGridData(1));
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDActionListComposite.this.pushRemoveButton(e);
            }
        });
    }

    protected abstract void pushDownButton(SelectionEvent var1);

    protected abstract void pushUpButton(SelectionEvent var1);

    protected abstract void pushRemoveButton(SelectionEvent var1);

    private void selectActionList(SelectionEvent e) {
        this.actionList.getSelectionCount();
        this.availableActions.deselectAll();
        this.availableActions.refreshButtons();
        this.refreshButtons();
    }

    protected abstract void addActions(List var1);

    protected abstract void addAction(SDAction var1);

    protected CompoundCommand getActionCommands() {
        return this.actionCommands;
    }

    protected void addActionCommand(Command command) {
        this.actionCommands.add(command);
    }

    protected void deselectAll() {
        this.getActionList().deselectAll();
    }

    protected void setActionListSize(int w, int h) {
        this.actionList.setSize(w, h);
    }

    protected void setLabelText(String labelText) {
        this.label.setText(labelText);
    }

    protected void setAvailableActions(SDAvaliableActionListComposite availableActions) {
        this.availableActions = availableActions;
        this.availableActions.addActionList(this, this.buttonAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)this.availableActions);
    }

    protected void refreshButtons() {
        int count = this.actionList.getSelectionCount();
        if (count > 0) {
            this.buttonRemove.setEnabled(true);
        } else {
            this.buttonRemove.setEnabled(false);
        }
        if (count == 1) {
            if (this.actionList.getSelectionIndex() != 0) {
                this.buttonUp.setEnabled(true);
            } else {
                this.buttonUp.setEnabled(false);
            }
            if (this.actionList.getSelectionIndex() != this.actionList.getItemCount() - 1) {
                this.buttonDown.setEnabled(true);
            } else {
                this.buttonDown.setEnabled(false);
            }
        } else {
            this.buttonUp.setEnabled(false);
            this.buttonDown.setEnabled(false);
        }
    }

    protected ObjectList getActionList() {
        return this.actionList;
    }

    protected SDEditDomain getDomain() {
        return this.domain;
    }
}

