/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.propertyedit;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import sdeditor.editpart.propertyedit.SDAvailableGuardConditionManager;
import sdeditor.editpart.propertyedit.SDCreateGuardConditionDialog;
import sdeditor.editpart.propertyedit.SDTransitionEditDialog;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDInternalGuardCondition;
import sdeditor.model.SDTransition;

public class SDEditGuardConditionGroup {
    private SDTransitionEditDialog parent;
    private Command changeGuardConditionCommand = null;
    private Combo guardConditionCombo = null;

    public SDEditGuardConditionGroup(SDTransitionEditDialog parent) {
        this.parent = parent;
    }

    public Command getChangeGuardConditionCommand() {
        return this.changeGuardConditionCommand;
    }

    public void addGuardGroup(Composite parent) {
        Group guardGroup = new Group(parent, 0);
        guardGroup.setLayoutData((Object)new GridData(768));
        guardGroup.setText("Guard Condition");
        GridData data = new GridData();
        data.widthHint = 630;
        guardGroup.setLayoutData((Object)data);
        guardGroup.setLayout(null);
        this.guardConditionCombo = new Combo((Composite)guardGroup, 8);
        this.guardConditionCombo.setLocation(15, 20);
        this.guardConditionCombo.setSize(200, 100);
        this.guardConditionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDEditGuardConditionGroup.this.guardConditionChanged(e);
            }
        });
        this.initializeGuardConditionCombo();
        Button createButton = new Button((Composite)guardGroup, 8);
        createButton.setText("New Internal GuardCondition");
        createButton.setLocation(240, 20);
        createButton.setSize(160, 20);
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDEditGuardConditionGroup.this.createGuardCondition(e);
            }
        });
        Button managerButton = new Button((Composite)guardGroup, 8);
        managerButton.setText("Available GuardCondition Manager");
        managerButton.setLocation(445, 30);
        managerButton.setSize(180, 20);
        managerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDEditGuardConditionGroup.this.controlGuardCondition(e);
            }
        });
    }

    private void initializeGuardConditionCombo() {
        ArrayList<SDGuardCondition> guardConditions = new ArrayList<SDGuardCondition>();
        guardConditions.add(SDTransition.defaultGuardCondition);
        guardConditions.addAll(this.parent.getDomain().getProject().getGuardConditions());
        guardConditions.addAll(this.parent.getDomain().getRootStateMachine().getInternalGuardConditions());
        this.guardConditionCombo.removeAll();
        Iterator i = guardConditions.iterator();
        while (i.hasNext()) {
            SDGuardCondition guard = (SDGuardCondition)i.next();
            this.guardConditionCombo.add(guard.getName());
            this.guardConditionCombo.setData(guard.getName(), (Object)guard);
        }
        int selectionIndex = guardConditions.indexOf(this.parent.getTransition().getGuardCondition());
        this.guardConditionCombo.select(selectionIndex);
    }

    private void controlGuardCondition(SelectionEvent e) {
        SDAvailableGuardConditionManager dialog = new SDAvailableGuardConditionManager(this.parent.getShell(), this.parent.getDomain());
        dialog.open();
    }

    private void createGuardCondition(SelectionEvent e) {
        SDCreateGuardConditionDialog dialog = new SDCreateGuardConditionDialog((EditDomain)this.parent.getDomain());
        int result = dialog.open();
        if (result == 0) {
            SDInternalGuardCondition guard = (SDInternalGuardCondition)dialog.getNewGuardCondition();
            this.initializeGuardConditionCombo();
            this.changeGuardConditionCommand = this.parent.getDomain().SetGuardConditionToTransitionCommand(this.parent.getTransition(), guard);
            this.guardConditionCombo.setText(guard.getName());
        }
    }

    private void guardConditionChanged(ModifyEvent e) {
        SDGuardCondition guard = (SDGuardCondition)this.guardConditionCombo.getData(this.guardConditionCombo.getText());
        this.changeGuardConditionCommand = this.parent.getDomain().SetGuardConditionToTransitionCommand(this.parent.getTransition(), guard);
    }
}

