/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.widgets.Tree;
import sdeditor.model.SDAction;
import sdeditor.model.SDElement;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTransition;
import sdeditor.model.SDTransitionLabel;

public class SDTreeElementEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.editpart.tree.SDTreeElementEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public SDTreeElementEditPart(Object model) {
        super(model);
    }

    public SDElement getElement() {
        return (SDElement)this.getModel();
    }

    public void activate() {
        if (super.isActive()) {
            return;
        }
        logger.debug((Object)"activate");
        super.activate();
        this.getElement().addPropertyChangeListener(this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        logger.debug((Object)"deactivate");
        super.deactivate();
        this.getElement().removePropertyChangeListener(this);
    }

    protected void createEditPolicies() {
        logger.debug((Object)"in");
    }

    protected List getModelChildren() {
        ArrayList<SDTransitionLabel> children = new ArrayList<SDTransitionLabel>();
        if (this.getElement() instanceof SDStateMachine) {
            children.addAll(((SDStateMachine)((Object)this.getElement())).getAllStates());
        }
        if (this.getElement() instanceof SDState) {
            children.addAll(((SDState)this.getElement()).getSourceTransitions());
        }
        if (this.getElement() instanceof SDTransition) {
            children.add(((SDTransition)this.getElement()).getLabel());
        }
        return children;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("rectangle")) {
            this.refreshVisuals();
        } else if (propName.equals("child")) {
            this.refreshChildren();
        } else if (propName.equals("transition")) {
            this.refreshChildren();
        }
    }

    protected void refreshVisuals() {
        logger.debug((Object)"in");
        if (this.getWidget() instanceof Tree) {
            return;
        }
        if (this.getElement() instanceof SDState) {
            super.setWidgetText(((SDState)this.getElement()).getName());
        } else if (this.getElement() instanceof SDTransition) {
            super.setWidgetText("Transition");
        } else if (this.getElement() instanceof SDTransitionLabel) {
            super.setWidgetText(this.createLabelText((SDTransitionLabel)this.getElement()));
        } else {
            super.setWidgetText(this.getModel().toString());
        }
    }

    public String createLabelText(SDTransitionLabel label) {
        SDGuardCondition guard;
        StringBuffer buffer = new StringBuffer();
        SDEvent event = label.getEvent();
        if (event != SDTransition.defaultEvent) {
            buffer.append(event.getName());
        }
        if ((guard = label.getGuardCondition()) != SDTransition.defaultGuardCondition) {
            buffer.append("[");
            buffer.append(guard.getName());
            buffer.append("]");
        }
        List actions = label.getActions();
        int len = actions.size();
        int i = 0;
        while (i < len) {
            if (i == 0) {
                buffer.append("/");
            } else {
                buffer.append(",");
            }
            SDAction action = (SDAction)actions.get(i);
            buffer.append(action.getName());
            ++i;
        }
        return buffer.toString();
    }
}

