/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class SDRelativePoint {
    public static final Dimension defaultDimension = new Dimension(0, 0);
    public static final float defaultWeight = 0.5f;
    private Dimension d1;
    private Dimension d2;
    private float weight;

    public static SDRelativePoint createInstance(Point p, Point pSrc, Point pTgt) {
        Dimension d1 = p.getDifference(pSrc);
        Dimension d2 = p.getDifference(pTgt);
        float f1 = (float)p.getDistance(pSrc);
        float f2 = (float)p.getDistance(pTgt);
        float distance = f1 + f2;
        float weight = f1 / distance;
        return new SDRelativePoint(d1, d2, weight);
    }

    public SDRelativePoint() {
        this(defaultDimension, defaultDimension, 0.5f);
    }

    public SDRelativePoint(Dimension d1, Dimension d2) {
        this(d1, d2, 0.5f);
    }

    public SDRelativePoint(Dimension d1, Dimension d2, float weight) {
        this.d1 = d1;
        this.d2 = d2;
        this.weight = weight;
    }

    public Dimension getD1() {
        return this.d1;
    }

    public Dimension getD2() {
        return this.d2;
    }

    public float getWeight() {
        return this.weight;
    }

    protected void setD1(Dimension d1) {
        this.d1 = d1;
    }

    protected void setD2(Dimension d2) {
        this.d2 = d2;
    }
}

