/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import sdeditor.SDEditorException;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDState;
import sdeditor.model.SDTransition;

public class SDSelfTransition
extends SDTransition {
    private static final int WIDTH = 25;
    private static final int HEIGHT = 20;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private int direction = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDSelfTransition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static SDSelfTransition createSelfTransition(int direction) {
        SDSelfTransition selfTransition = new SDSelfTransition(direction);
        return selfTransition;
    }

    protected SDSelfTransition(int direction) {
        this.direction = direction;
    }

    protected void refreshBendpoints() {
        if (!($assertionsDisabled || this.getSourceState() != null && this.getSourceState() == this.getTargetState())) {
            throw new AssertionError();
        }
        super.removeAllBendpoints();
        SDState state = this.getSourceState();
        Rectangle r = state.getBounds();
        Dimension d = this.getMargin(r);
        switch (this.direction) {
            case 1: {
                this.refreshRight(d);
                return;
            }
            case 2: {
                this.refreshLeft(d);
                return;
            }
            case 3: {
                this.refreshTop(d);
                return;
            }
            case 4: {
                this.refreshBottom(d);
                return;
            }
        }
        throw new SDEditorException("unknown direction");
    }

    private Dimension getMargin(Rectangle r) {
        int width = r.width / 2;
        int height = r.height / 2;
        return new Dimension(width, height);
    }

    private void refreshRight(Dimension d) {
        Dimension[] points = new Dimension[]{new Dimension(d.width + 20, 25), new Dimension(d.width + 20, -25)};
        Dimension label = new Dimension(d.width + 20, 0);
        this.refreshImpl(points, label);
    }

    private void refreshLeft(Dimension d) {
        Dimension[] points = new Dimension[]{new Dimension(-d.width - 20, 25), new Dimension(-d.width - 20, -25)};
        Dimension label = new Dimension(-d.width - 20, 0);
        this.refreshImpl(points, label);
    }

    private void refreshTop(Dimension d) {
        Dimension[] points = new Dimension[]{new Dimension(25, -d.height - 20), new Dimension(-25, -d.height - 20)};
        Dimension label = new Dimension(0, -d.height - 20);
        this.refreshImpl(points, label);
    }

    private void refreshBottom(Dimension d) {
        Dimension[] points = new Dimension[]{new Dimension(25, d.height + 20), new Dimension(-25, d.height + 20)};
        Dimension label = new Dimension(0, d.height + 20);
        this.refreshImpl(points, label);
    }

    private void refreshImpl(Dimension[] points, Dimension label) {
        int len = points.length;
        int i = 0;
        while (i < len) {
            this.addBendpoint(new SDRelativePoint(points[i], points[i]), i);
            ++i;
        }
        this.getLabel().setLocation(new SDRelativePoint(label, label));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

