/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import sdeditor.model.SDAction;
import sdeditor.model.SDActionList;
import sdeditor.model.SDElement;
import sdeditor.model.SDTransition;

public abstract class SDState
extends SDElement {
    private static final Logger logger;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private List sourceTransitions = new ArrayList();
    private List targetTransitions = new ArrayList();
    private SDActionList entryActions = new SDActionList();
    private SDActionList doActions = new SDActionList();
    private SDActionList exitActions = new SDActionList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("sdeditor.model.SDState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public abstract String getName();

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void setBounds(Rectangle bounds) {
        Rectangle oldBounds = this.bounds;
        this.bounds = bounds;
        super.firePropertyChange("rectangle", oldBounds, this.bounds);
    }

    public Dimension getSize() {
        return this.bounds.getSize();
    }

    protected void setSize(Dimension size) {
        if (!$assertionsDisabled && size == null) {
            throw new AssertionError((Object)"Size is null!");
        }
        Point p = this.bounds.getLocation();
        this.setBounds(new Rectangle(p, size));
    }

    public Point getLocation() {
        return this.bounds.getLocation();
    }

    protected void setLocation(Point location) {
        if (!$assertionsDisabled && location == null) {
            throw new AssertionError((Object)"Location is null!");
        }
        Dimension d = this.bounds.getSize();
        this.setBounds(new Rectangle(location, d));
    }

    public List getSourceTransitions() {
        return new ArrayList(this.sourceTransitions);
    }

    protected void addSourceTransition(SDTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Added source transition is null!");
        }
        if (!$assertionsDisabled && this.sourceTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.sourceTransitions.add(transition);
        super.fireStructureChange("transition", transition);
    }

    protected void removeSourceTransition(SDTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Removed source transition is null!");
        }
        if (!$assertionsDisabled && !this.sourceTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.sourceTransitions.remove(transition);
        super.fireStructureChange("transition", transition);
    }

    public List getTargetTransitions() {
        return new ArrayList(this.targetTransitions);
    }

    protected void addTargetTransition(SDTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Added TargetTransition is null!");
        }
        if (!$assertionsDisabled && this.targetTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.targetTransitions.add(transition);
        super.fireStructureChange("transition", transition);
    }

    protected void removeTargetTransition(SDTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Removed target transition is null!");
        }
        if (!$assertionsDisabled && !this.targetTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.targetTransitions.remove(transition);
        super.fireStructureChange("transition", transition);
    }

    public List getAllActions() {
        ArrayList list = new ArrayList();
        list.addAll(this.entryActions.getActions());
        list.addAll(this.doActions.getActions());
        list.addAll(this.exitActions.getActions());
        return list;
    }

    public List getEntryActions() {
        return this.entryActions.getActions();
    }

    protected void addEntryAction(SDAction action) {
        this.entryActions.addAction(action);
        super.fireStructureChange("rectangle", action);
    }

    protected void addEntryAction(SDAction action, int index) {
        this.entryActions.addAction(action, index);
        super.fireStructureChange("rectangle", action);
    }

    protected void removeEntryAction(int index) {
        SDAction action = this.entryActions.removeAction(index);
        super.fireStructureChange("rectangle", action);
    }

    protected void moveEntryAction(int index, int move) {
        SDAction action = this.entryActions.moveAction(index, move);
        super.fireStructureChange("rectangle", action);
    }

    public List getDoActions() {
        return this.doActions.getActions();
    }

    protected void addDoAction(SDAction action) {
        this.doActions.addAction(action);
        super.fireStructureChange("rectangle", action);
    }

    protected void addDoAction(SDAction action, int index) {
        this.doActions.addAction(action, index);
        super.fireStructureChange("rectangle", action);
    }

    protected void removeDoAction(int index) {
        SDAction action = this.doActions.removeAction(index);
        super.fireStructureChange("rectangle", action);
    }

    protected void moveDoAction(int index, int move) {
        SDAction action = this.doActions.moveAction(index, move);
        super.fireStructureChange("rectangle", action);
    }

    public List getExitActions() {
        return this.exitActions.getActions();
    }

    protected void addExitAction(SDAction action) {
        this.exitActions.addAction(action);
        super.fireStructureChange("rectangle", action);
    }

    protected void addExitAction(SDAction action, int index) {
        this.exitActions.addAction(action, index);
        super.fireStructureChange("rectangle", action);
    }

    protected void removeExitAction(int index) {
        SDAction action = this.exitActions.removeAction(index);
        super.fireStructureChange("rectangle", action);
    }

    protected void moveExitAction(int index, int move) {
        SDAction action = this.exitActions.moveAction(index, move);
        super.fireStructureChange("rectangle", action);
    }
}

