/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import sdeditor.model.SDAction;
import sdeditor.model.SDActionList;
import sdeditor.model.SDElement;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDState;
import sdeditor.model.SDTransitionLabel;

public class SDTransition
extends SDElement {
    public static final String defaultEventName = "AUTO";
    public static final String defaultGuardConditionName = "EVERY";
    public static final SDEvent defaultEvent;
    public static final SDGuardCondition defaultGuardCondition;
    private SDEvent event = defaultEvent;
    private SDGuardCondition guardCondition = defaultGuardCondition;
    private SDActionList actions = new SDActionList();
    private SDState sourceState = null;
    private SDState targetState = null;
    private List bendpoints = new LinkedList();
    private SDTransitionLabel label = new SDTransitionLabel(this);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDTransition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        defaultEvent = new SDEvent(){

            public String getName() {
                return SDTransition.defaultEventName;
            }
        };
        defaultGuardCondition = new SDGuardCondition(){

            public String getName() {
                return SDTransition.defaultGuardConditionName;
            }
        };
    }

    public SDEvent getEvent() {
        return this.event;
    }

    protected void setEvent(SDEvent event) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError((Object)"Set event is null");
        }
        this.event = event;
        this.label.refreshText();
    }

    public SDGuardCondition getGuardCondition() {
        return this.guardCondition;
    }

    protected void setGuardCondition(SDGuardCondition guardCondition) {
        if (!$assertionsDisabled && guardCondition == null) {
            throw new AssertionError((Object)"Set guard Condition is null");
        }
        this.guardCondition = guardCondition;
        this.label.refreshText();
    }

    public List getActions() {
        return this.actions.getActions();
    }

    protected void addAction(SDAction newAction) {
        this.actions.addAction(newAction);
        this.label.refreshText();
    }

    protected void addAction(SDAction action, int index) {
        this.actions.addAction(action, index);
        this.label.refreshText();
    }

    protected SDAction removeAction(int index) {
        SDAction action = this.actions.removeAction(index);
        this.label.refreshText();
        return action;
    }

    protected void moveAction(int index, int move) {
        this.actions.moveAction(index, move);
        this.label.refreshText();
    }

    public SDState getSourceState() {
        return this.sourceState;
    }

    public SDState getTargetState() {
        return this.targetState;
    }

    protected void setSourceState(SDState sourceState) {
        if (!$assertionsDisabled && sourceState == null) {
            throw new AssertionError((Object)"Set state is null");
        }
        this.sourceState = sourceState;
    }

    protected void setTargetState(SDState targetState) {
        if (!$assertionsDisabled && targetState == null) {
            throw new AssertionError((Object)"Set state is null");
        }
        this.targetState = targetState;
    }

    public List getBendpoints() {
        return new LinkedList(this.bendpoints);
    }

    protected void addBendpoint(SDRelativePoint bendPoint, int index) {
        if (!$assertionsDisabled && bendPoint == null) {
            throw new AssertionError((Object)"Added bend point is null!");
        }
        this.bendpoints.add(index, bendPoint);
        this.fireStructureChange("rectangle", this);
    }

    protected SDRelativePoint removeBendpoint(int index) {
        if (!$assertionsDisabled && index >= this.bendpoints.size()) {
            throw new AssertionError((Object)"illegal index");
        }
        SDRelativePoint point = (SDRelativePoint)this.bendpoints.remove(index);
        this.fireStructureChange("rectangle", this);
        return point;
    }

    protected List removeAllBendpoints() {
        if (!this.bendpoints.isEmpty()) {
            ArrayList list = new ArrayList(this.bendpoints);
            this.bendpoints.clear();
            this.fireStructureChange("rectangle", this);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    protected void moveBendpoint(int index, SDRelativePoint bendpoint) {
        if (!$assertionsDisabled && bendpoint == null) {
            throw new AssertionError((Object)"Added bend point is null!");
        }
        if (!$assertionsDisabled && index >= this.bendpoints.size()) {
            throw new AssertionError((Object)"illegal index");
        }
        this.bendpoints.remove(index);
        this.bendpoints.add(index, bendpoint);
        this.fireStructureChange("rectangle", this);
    }

    public SDTransitionLabel getLabel() {
        return this.label;
    }
}

