/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.serialize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import sdeditor.SDEditorException;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDDocument;
import sdeditor.model.SDElement;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDHistoryState;
import sdeditor.model.SDInitialState;
import sdeditor.model.SDProject;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDSpecialState;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTerminalState;
import sdeditor.model.SDTransition;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.XAction;
import sdeditor.model.xml.XCompositeState;
import sdeditor.model.xml.XEvent;
import sdeditor.model.xml.XGuardCondition;
import sdeditor.model.xml.XPoint;
import sdeditor.model.xml.XRelativePoint;
import sdeditor.model.xml.XRootStateMachine;
import sdeditor.model.xml.XSize;
import sdeditor.model.xml.XSpecialState;
import sdeditor.model.xml.XState;
import sdeditor.model.xml.XStateMachine;
import sdeditor.model.xml.XTransition;
import trier.util.EIdMap;

public class SDXMLInput {
    private EIdMap idMap = null;
    private SDDocument doc = null;
    private SDProject project = null;

    public SDXMLInput(SDProject project) {
        this.project = project;
    }

    private void initialize() {
        this.idMap = new EIdMap();
        this.doc = new SDDocument();
    }

    public SDDocument process(XRootStateMachine xRoot) {
        this.initialize();
        this.setSDRootStateMachine(xRoot);
        return this.doc;
    }

    private SDElement createSDElement(IRNode xElement) {
        try {
            if (xElement == null) {
                return null;
            }
            if (xElement instanceof XCompositeState) {
                return this.createSDCompositeState((XCompositeState)xElement);
            }
            if (xElement instanceof XSpecialState) {
                return this.createSDSpecialState((XSpecialState)xElement);
            }
            if (xElement instanceof XEvent) {
                return this.createSDEvent((XEvent)xElement);
            }
            if (xElement instanceof XGuardCondition) {
                return this.createSDGuardCondition((XGuardCondition)xElement);
            }
            if (xElement instanceof XAction) {
                return this.createSDAction((XAction)xElement);
            }
            if (xElement instanceof XTransition) {
                return this.createSDTransition((XTransition)xElement);
            }
            throw new SDEditorException("Illegal Element Type for XML to Model");
        }
        catch (Exception ex) {
            throw new SDEditorException("Exception in parsing XML", ex);
        }
    }

    private List createSDElements(IRNode[] nodes) {
        ArrayList<SDElement> sdElements = new ArrayList<SDElement>();
        int i = 0;
        while (i < nodes.length) {
            sdElements.add(this.createSDElement(nodes[i]));
            ++i;
        }
        return sdElements;
    }

    private void setSDRootStateMachine(XRootStateMachine xRoot) {
        this.createSDElements(xRoot.getEvents().getEvent());
        this.createSDElements(xRoot.getGuardConditions().getGuardCondition());
        this.createSDElements(xRoot.getActions().getAction());
        this.setSDStateMachine(this.doc.getRootStateMachine(), xRoot.getStateMachine());
        this.createSDElements(xRoot.getTransitions().getTransition());
    }

    private void setSDStateMachine(SDStateMachine sdStateMachine, XStateMachine xStateMachine) {
        XSpecialState xHState;
        List states = this.createSDElements(xStateMachine.getCompositeStates().getCompositeState());
        Iterator i = states.iterator();
        while (i.hasNext()) {
            sdStateMachine.addState((SDCompositeState)i.next());
        }
        XSpecialState xInitialState = xStateMachine.getInitialState().getSpecialState();
        if (xInitialState != null) {
            SDInitialState sdInitialState = (SDInitialState)this.createSDSpecialState(xInitialState);
            sdStateMachine.setInitialState(sdInitialState);
        }
        List finalStates = this.createSDElements(xStateMachine.getTerminalStates().getSpecialState());
        i = finalStates.iterator();
        while (i.hasNext()) {
            sdStateMachine.addTerminalState((SDTerminalState)i.next());
        }
        if (sdStateMachine instanceof SDCompositeState && (xHState = xStateMachine.getHistoryState().getSpecialState()) != null) {
            SDHistoryState sdHState = (SDHistoryState)this.createSDSpecialState(xHState);
            ((SDCompositeState)sdStateMachine).setHistoryState(sdHState);
        }
    }

    private SDState setSDState(SDState sdState, XState xState) {
        Rectangle r = new Rectangle(this.createPoint(xState.getPoint()), this.createSize(xState.getSize()));
        this.doc.setBoundsToState(sdState, r);
        String[] ids = xState.getEntryActions();
        int i = 0;
        while (i < ids.length) {
            this.doc.addActionToState(sdState, 1, (SDAction)this.idMap.getObject(ids[i]));
            ++i;
        }
        ids = xState.getDoActions();
        i = 0;
        while (i < ids.length) {
            this.doc.addActionToState(sdState, 2, (SDAction)this.idMap.getObject(ids[i]));
            ++i;
        }
        ids = xState.getExitActions();
        i = 0;
        while (i < ids.length) {
            this.doc.addActionToState(sdState, 3, (SDAction)this.idMap.getObject(ids[i]));
            ++i;
        }
        this.idMap.putObject(xState.getId(), (Object)sdState);
        return sdState;
    }

    private SDCompositeState createSDCompositeState(XCompositeState xCompositeState) {
        SDCompositeState sdState = new SDCompositeState();
        this.doc.setNameToState(sdState, xCompositeState.getName());
        this.setSDState(sdState, xCompositeState.getState());
        this.setSDStateMachine(sdState, xCompositeState.getStateMachine());
        return sdState;
    }

    private SDState createSDSpecialState(XSpecialState xSpecialState) {
        SDSpecialState sdState = null;
        if (xSpecialState.getType().equals("INITIALSTATE")) {
            sdState = new SDInitialState();
        } else if (xSpecialState.getType().equals("TERMINALSTATE")) {
            sdState = new SDTerminalState();
        } else if (xSpecialState.getType().equals("HISTORYSTATE")) {
            sdState = new SDHistoryState();
        } else {
            throw new SDEditorException("Illegal State Type for XML to Model");
        }
        this.setSDState(sdState, xSpecialState.getState());
        return sdState;
    }

    private SDTransition createSDTransition(XTransition xTransition) {
        String guardConditionId;
        SDState source = (SDState)this.idMap.getObject(xTransition.getSource());
        SDState target = (SDState)this.idMap.getObject(xTransition.getTarget());
        SDTransition sdTransition = this.doc.createTransition(source, target);
        String eventId = xTransition.getEvent();
        if (!eventId.equals("AUTO")) {
            this.doc.setEventToTransition(sdTransition, (SDEvent)this.idMap.getObject(eventId));
        }
        if (!(guardConditionId = xTransition.getGuardCondition()).equals("EVERY")) {
            this.doc.setGuardConditionToTransition(sdTransition, (SDGuardCondition)this.idMap.getObject(guardConditionId));
        }
        String[] actionIds = xTransition.getActions();
        int i = 0;
        while (i < actionIds.length) {
            this.doc.addActionToTransition(sdTransition, (SDAction)this.idMap.getObject(actionIds[i]));
            ++i;
        }
        XRelativePoint[] points = xTransition.getBendpoints().getRelativePoint();
        int i2 = 0;
        while (i2 < points.length) {
            this.doc.addBendpointToTransition(sdTransition, this.createRelativePoint(points[i2]), i2);
            ++i2;
        }
        this.doc.setLocationToTransitionLabel(sdTransition.getLabel(), this.createRelativePoint(xTransition.getTransitionLabel().getRelativePoint()));
        return sdTransition;
    }

    private SDEvent createSDEvent(XEvent xEvent) throws ClassNotFoundException {
        SDEvent sdEvent = null;
        if (xEvent.getType().equals("INTERNAL")) {
            sdEvent = this.doc.createInternalEvent(xEvent.getName());
        } else if (xEvent.getType().equals("TEMPLATE")) {
            sdEvent = this.project.getEvent(xEvent.getName());
        } else {
            throw new SDEditorException("Illegal Event Type for XML to Model");
        }
        this.idMap.putObject(xEvent.getId(), (Object)sdEvent);
        return sdEvent;
    }

    private SDGuardCondition createSDGuardCondition(XGuardCondition xGuardCondition) throws ClassNotFoundException {
        SDGuardCondition sdGuardCondition = null;
        if (xGuardCondition.getType().equals("INTERNAL")) {
            sdGuardCondition = this.doc.createInternalGuardCondition(xGuardCondition.getName());
        } else if (xGuardCondition.getType().equals("TEMPLATE")) {
            sdGuardCondition = this.project.getGuardCondition(xGuardCondition.getName());
        } else {
            throw new SDEditorException("Illegal GuardCondition Type for XML to Model");
        }
        this.idMap.putObject(xGuardCondition.getId(), (Object)sdGuardCondition);
        return sdGuardCondition;
    }

    private SDAction createSDAction(XAction xAction) throws ClassNotFoundException {
        SDAction sdAction = null;
        if (xAction.getType().equals("INTERNAL")) {
            sdAction = this.doc.createInternalAction(xAction.getName());
        } else if (xAction.getType().equals("TEMPLATE")) {
            sdAction = this.project.getAction(xAction.getName());
        } else {
            throw new SDEditorException("Illegal Action Type for XML to Model");
        }
        this.idMap.putObject(xAction.getId(), (Object)sdAction);
        return sdAction;
    }

    private Point createPoint(XPoint xPoint) {
        return new Point(xPoint.getX(), xPoint.getY());
    }

    private Dimension createSize(XSize xSize) {
        return new Dimension(xSize.getWidth(), xSize.getHeight());
    }

    private SDRelativePoint createRelativePoint(XRelativePoint xPoint) {
        Dimension d1 = this.createSize(xPoint.getSize1());
        Dimension d2 = this.createSize(xPoint.getSize2());
        float weight = xPoint.getWeight();
        return new SDRelativePoint(d1, d2, weight);
    }
}

