/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;

public class XAction
implements Serializable,
IRNode {
    private String id_;
    private String type_;
    private String name_;
    private IRNode parentRNode_;

    public XAction() {
    }

    public XAction(RStack stack) {
        this.setup(stack);
    }

    public XAction(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XAction(Element element) {
        this.setup(element);
    }

    public XAction(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XAction(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XAction(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XAction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XAction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XAction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        StateDiagramFactory.getFactory();
        new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("action");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        URelaxer.setAttributePropertyByString(element, "type", this.type_);
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<action");
        buffer.append(" id=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getId()));
        buffer.append("\"");
        buffer.append(" type=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getType()));
        buffer.append("\"");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getName()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</action>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<action");
        buffer.print(" id=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getId()));
        buffer.print("\"");
        buffer.print(" type=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getType()));
        buffer.print("\"");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getName()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</action>");
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "action")) {
            return false;
        }
        RStack target = new RStack(element);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XAction.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XAction.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

