/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XAction;

public class XActions
implements Serializable,
IRNode {
    private List action_ = new ArrayList();
    private IRNode parentRNode_;

    public XActions() {
    }

    public XActions(RStack stack) {
        this.setup(stack);
    }

    public XActions(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XActions(Element element) {
        this.setup(element);
    }

    public XActions(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XActions(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XActions(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XActions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XActions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XActions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.action_.clear();
        while (!stack.isEmptyElement()) {
            if (!XAction.isMatch(stack)) break;
            this.addAction(factory.createXAction(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("actions");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            XAction value = (XAction)this.action_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XAction[] getAction() {
        XAction[] array = new XAction[this.action_.size()];
        return this.action_.toArray(array);
    }

    public final void setAction(XAction[] action) {
        this.action_.clear();
        this.action_.addAll(Arrays.asList(action));
        int i = 0;
        while (i < action.length) {
            action[i].setParentRNode(this);
            ++i;
        }
    }

    public final void setAction(XAction action) {
        this.action_.clear();
        this.action_.add(action);
        if (action != null) {
            action.setParentRNode(this);
        }
    }

    public final void addAction(XAction action) {
        this.action_.add(action);
        if (action != null) {
            action.setParentRNode(this);
        }
    }

    public final int getActionCount() {
        return this.action_.size();
    }

    public final XAction getAction(int index) {
        return (XAction)this.action_.get(index);
    }

    public final void setAction(int index, XAction action) {
        this.action_.set(index, action);
    }

    public final void removeAction(int index) {
        this.action_.remove(index);
    }

    public final void removeAction(XAction action) {
        this.action_.remove(action);
    }

    public final void clearAction() {
        this.action_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<actions");
        buffer.append(">");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            XAction value = (XAction)this.action_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</actions>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<actions");
        buffer.print(">");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            XAction value = (XAction)this.action_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</actions>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.action_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "actions")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!XAction.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XActions.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XActions.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

