/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XEvent;

public class XEvents
implements Serializable,
IRNode {
    private List event_ = new ArrayList();
    private IRNode parentRNode_;

    public XEvents() {
    }

    public XEvents(RStack stack) {
        this.setup(stack);
    }

    public XEvents(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XEvents(Element element) {
        this.setup(element);
    }

    public XEvents(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XEvents(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XEvents(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XEvents(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XEvents(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XEvents(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.event_.clear();
        while (!stack.isEmptyElement()) {
            if (!XEvent.isMatch(stack)) break;
            this.addEvent(factory.createXEvent(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("events");
        int size = this.event_.size();
        int i = 0;
        while (i < size) {
            XEvent value = (XEvent)this.event_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XEvent[] getEvent() {
        XEvent[] array = new XEvent[this.event_.size()];
        return this.event_.toArray(array);
    }

    public final void setEvent(XEvent[] event) {
        this.event_.clear();
        this.event_.addAll(Arrays.asList(event));
        int i = 0;
        while (i < event.length) {
            event[i].setParentRNode(this);
            ++i;
        }
    }

    public final void setEvent(XEvent event) {
        this.event_.clear();
        this.event_.add(event);
        if (event != null) {
            event.setParentRNode(this);
        }
    }

    public final void addEvent(XEvent event) {
        this.event_.add(event);
        if (event != null) {
            event.setParentRNode(this);
        }
    }

    public final int getEventCount() {
        return this.event_.size();
    }

    public final XEvent getEvent(int index) {
        return (XEvent)this.event_.get(index);
    }

    public final void setEvent(int index, XEvent event) {
        this.event_.set(index, event);
    }

    public final void removeEvent(int index) {
        this.event_.remove(index);
    }

    public final void removeEvent(XEvent event) {
        this.event_.remove(event);
    }

    public final void clearEvent() {
        this.event_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<events");
        buffer.append(">");
        int size = this.event_.size();
        int i = 0;
        while (i < size) {
            XEvent value = (XEvent)this.event_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</events>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<events");
        buffer.print(">");
        int size = this.event_.size();
        int i = 0;
        while (i < size) {
            XEvent value = (XEvent)this.event_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</events>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.event_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "events")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!XEvent.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XEvents.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XEvents.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

