/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;

public class XPoint
implements Serializable,
IRNode {
    private int x_;
    private int y_;
    private IRNode parentRNode_;

    public XPoint() {
    }

    public XPoint(RStack stack) {
        this.setup(stack);
    }

    public XPoint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XPoint(Element element) {
        this.setup(element);
    }

    public XPoint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XPoint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XPoint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XPoint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XPoint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XPoint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        StateDiagramFactory.getFactory();
        new RStack(element);
        this.x_ = URelaxer.getAttributePropertyAsInt(element, "x");
        this.y_ = URelaxer.getAttributePropertyAsInt(element, "y");
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("point");
        URelaxer.setAttributePropertyByInt(element, "x", this.x_);
        URelaxer.setAttributePropertyByInt(element, "y", this.y_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final int getX() {
        return this.x_;
    }

    public final void setX(int x) {
        this.x_ = x;
    }

    public final int getY() {
        return this.y_;
    }

    public final void setY(int y) {
        this.y_ = y;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<point");
        buffer.append(" x=\"");
        buffer.append(Integer.toString(this.getX()));
        buffer.append("\"");
        buffer.append(" y=\"");
        buffer.append(Integer.toString(this.getY()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</point>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<point");
        buffer.print(" x=\"");
        buffer.print(Integer.toString(this.getX()));
        buffer.print("\"");
        buffer.print(" y=\"");
        buffer.print(Integer.toString(this.getY()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</point>");
    }

    public String getXAsString() {
        return URelaxer.getString(this.getX());
    }

    public String getYAsString() {
        return URelaxer.getString(this.getY());
    }

    public void setXByString(String string) {
        this.setX(Integer.parseInt(string));
    }

    public void setYByString(String string) {
        this.setY(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "point")) {
            return false;
        }
        RStack target = new RStack(element);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XPoint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XPoint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

