/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XSize;

public class XRelativePoint
implements Serializable,
IRNode {
    private float weight_;
    private XSize size1_;
    private XSize size2_;
    private IRNode parentRNode_;

    public XRelativePoint() {
    }

    public XRelativePoint(RStack stack) {
        this.setup(stack);
    }

    public XRelativePoint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XRelativePoint(Element element) {
        this.setup(element);
    }

    public XRelativePoint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XRelativePoint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XRelativePoint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XRelativePoint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XRelativePoint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XRelativePoint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.weight_ = URelaxer.getAttributePropertyAsFloat(element, "weight");
        this.setSize1(factory.createXSize(stack));
        this.setSize2(factory.createXSize(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("relativePoint");
        URelaxer.setAttributePropertyByFloat(element, "weight", this.weight_);
        this.size1_.makeElement(element);
        this.size2_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final float getWeight() {
        return this.weight_;
    }

    public final void setWeight(float weight) {
        this.weight_ = weight;
    }

    public final XSize getSize1() {
        return this.size1_;
    }

    public final void setSize1(XSize size1) {
        this.size1_ = size1;
        if (size1 != null) {
            size1.setParentRNode(this);
        }
    }

    public final XSize getSize2() {
        return this.size2_;
    }

    public final void setSize2(XSize size2) {
        this.size2_ = size2;
        if (size2 != null) {
            size2.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<relativePoint");
        buffer.append(" weight=\"");
        buffer.append(Float.toString(this.getWeight()));
        buffer.append("\"");
        buffer.append(">");
        this.size1_.makeTextElement(buffer);
        this.size2_.makeTextElement(buffer);
        buffer.append("</relativePoint>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<relativePoint");
        buffer.print(" weight=\"");
        buffer.print(Float.toString(this.getWeight()));
        buffer.print("\"");
        buffer.print(">");
        this.size1_.makeTextElement(buffer);
        this.size2_.makeTextElement(buffer);
        buffer.print("</relativePoint>");
    }

    public String getWeightAsString() {
        return URelaxer.getString(this.getWeight());
    }

    public void setWeightByString(String string) {
        this.setWeight(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<XSize> classNodes = new ArrayList<XSize>();
        classNodes.add(this.size1_);
        classNodes.add(this.size2_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "relativePoint")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XSize.isMatchHungry(target)) {
            return false;
        }
        if (!XSize.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XRelativePoint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XRelativePoint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

