/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;

public class XSize
implements Serializable,
IRNode {
    private int width_;
    private int height_;
    private IRNode parentRNode_;

    public XSize() {
    }

    public XSize(RStack stack) {
        this.setup(stack);
    }

    public XSize(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XSize(Element element) {
        this.setup(element);
    }

    public XSize(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XSize(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XSize(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XSize(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XSize(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XSize(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        StateDiagramFactory.getFactory();
        new RStack(element);
        this.width_ = URelaxer.getAttributePropertyAsInt(element, "width");
        this.height_ = URelaxer.getAttributePropertyAsInt(element, "height");
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("size");
        URelaxer.setAttributePropertyByInt(element, "width", this.width_);
        URelaxer.setAttributePropertyByInt(element, "height", this.height_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final int getWidth() {
        return this.width_;
    }

    public final void setWidth(int width) {
        this.width_ = width;
    }

    public final int getHeight() {
        return this.height_;
    }

    public final void setHeight(int height) {
        this.height_ = height;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<size");
        buffer.append(" width=\"");
        buffer.append(Integer.toString(this.getWidth()));
        buffer.append("\"");
        buffer.append(" height=\"");
        buffer.append(Integer.toString(this.getHeight()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</size>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<size");
        buffer.print(" width=\"");
        buffer.print(Integer.toString(this.getWidth()));
        buffer.print("\"");
        buffer.print(" height=\"");
        buffer.print(Integer.toString(this.getHeight()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</size>");
    }

    public String getWidthAsString() {
        return URelaxer.getString(this.getWidth());
    }

    public String getHeightAsString() {
        return URelaxer.getString(this.getHeight());
    }

    public void setWidthByString(String string) {
        this.setWidth(Integer.parseInt(string));
    }

    public void setHeightByString(String string) {
        this.setHeight(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "size")) {
            return false;
        }
        RStack target = new RStack(element);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XSize.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XSize.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

