/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XState;

public class XSpecialState
implements Serializable,
IRNode {
    private String type_;
    private XState state_;
    private IRNode parentRNode_;

    public XSpecialState() {
    }

    public XSpecialState(RStack stack) {
        this.setup(stack);
    }

    public XSpecialState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XSpecialState(Element element) {
        this.setup(element);
    }

    public XSpecialState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XSpecialState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XSpecialState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XSpecialState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XSpecialState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XSpecialState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.setState(factory.createXState(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("specialState");
        URelaxer.setAttributePropertyByString(element, "type", this.type_);
        this.state_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final XState getState() {
        return this.state_;
    }

    public final void setState(XState state) {
        this.state_ = state;
        if (state != null) {
            state.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<specialState");
        buffer.append(" type=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getType()));
        buffer.append("\"");
        buffer.append(">");
        this.state_.makeTextElement(buffer);
        buffer.append("</specialState>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<specialState");
        buffer.print(" type=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getType()));
        buffer.print("\"");
        buffer.print(">");
        this.state_.makeTextElement(buffer);
        buffer.print("</specialState>");
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<XState> classNodes = new ArrayList<XState>();
        classNodes.add(this.state_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "specialState")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XState.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XSpecialState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XSpecialState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

