/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XPoint;
import sdeditor.model.xml.XSize;

public class XState
implements Serializable,
IRNode {
    private String id_;
    private List entryActions_ = new ArrayList();
    private List doActions_ = new ArrayList();
    private List exitActions_ = new ArrayList();
    private XPoint point_;
    private XSize size_;
    private IRNode parentRNode_;

    public XState() {
    }

    public XState(RStack stack) {
        this.setup(stack);
    }

    public XState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XState(Element element) {
        this.setup(element);
    }

    public XState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.entryActions_ = URelaxer.getAttributePropertyAsStringList(element, "entryActions");
        this.doActions_ = URelaxer.getAttributePropertyAsStringList(element, "doActions");
        this.exitActions_ = URelaxer.getAttributePropertyAsStringList(element, "exitActions");
        this.setPoint(factory.createXPoint(stack));
        this.setSize(factory.createXSize(stack));
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("state");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        URelaxer.setAttributePropertyByStringList(element, "entryActions", this.entryActions_);
        URelaxer.setAttributePropertyByStringList(element, "doActions", this.doActions_);
        URelaxer.setAttributePropertyByStringList(element, "exitActions", this.exitActions_);
        this.point_.makeElement(element);
        this.size_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String[] getEntryActions() {
        String[] array = new String[this.entryActions_.size()];
        return this.entryActions_.toArray(array);
    }

    public final void setEntryActions(String[] entryActions) {
        this.entryActions_.clear();
        this.entryActions_.addAll(Arrays.asList(entryActions));
    }

    public final void setEntryActions(String entryActions) {
        this.entryActions_.clear();
        this.entryActions_.add(entryActions);
    }

    public final void addEntryActions(String entryActions) {
        this.entryActions_.add(entryActions);
    }

    public final int getEntryActionsCount() {
        return this.entryActions_.size();
    }

    public final String getEntryActions(int index) {
        return (String)this.entryActions_.get(index);
    }

    public final void setEntryActions(int index, String entryActions) {
        this.entryActions_.set(index, entryActions);
    }

    public final void removeEntryActions(int index) {
        this.entryActions_.remove(index);
    }

    public final void removeEntryActions(String entryActions) {
        this.entryActions_.remove(entryActions);
    }

    public final void clearEntryActions() {
        this.entryActions_.clear();
    }

    public final String[] getDoActions() {
        String[] array = new String[this.doActions_.size()];
        return this.doActions_.toArray(array);
    }

    public final void setDoActions(String[] doActions) {
        this.doActions_.clear();
        this.doActions_.addAll(Arrays.asList(doActions));
    }

    public final void setDoActions(String doActions) {
        this.doActions_.clear();
        this.doActions_.add(doActions);
    }

    public final void addDoActions(String doActions) {
        this.doActions_.add(doActions);
    }

    public final int getDoActionsCount() {
        return this.doActions_.size();
    }

    public final String getDoActions(int index) {
        return (String)this.doActions_.get(index);
    }

    public final void setDoActions(int index, String doActions) {
        this.doActions_.set(index, doActions);
    }

    public final void removeDoActions(int index) {
        this.doActions_.remove(index);
    }

    public final void removeDoActions(String doActions) {
        this.doActions_.remove(doActions);
    }

    public final void clearDoActions() {
        this.doActions_.clear();
    }

    public final String[] getExitActions() {
        String[] array = new String[this.exitActions_.size()];
        return this.exitActions_.toArray(array);
    }

    public final void setExitActions(String[] exitActions) {
        this.exitActions_.clear();
        this.exitActions_.addAll(Arrays.asList(exitActions));
    }

    public final void setExitActions(String exitActions) {
        this.exitActions_.clear();
        this.exitActions_.add(exitActions);
    }

    public final void addExitActions(String exitActions) {
        this.exitActions_.add(exitActions);
    }

    public final int getExitActionsCount() {
        return this.exitActions_.size();
    }

    public final String getExitActions(int index) {
        return (String)this.exitActions_.get(index);
    }

    public final void setExitActions(int index, String exitActions) {
        this.exitActions_.set(index, exitActions);
    }

    public final void removeExitActions(int index) {
        this.exitActions_.remove(index);
    }

    public final void removeExitActions(String exitActions) {
        this.exitActions_.remove(exitActions);
    }

    public final void clearExitActions() {
        this.exitActions_.clear();
    }

    public final XPoint getPoint() {
        return this.point_;
    }

    public final void setPoint(XPoint point) {
        this.point_ = point;
        if (point != null) {
            point.setParentRNode(this);
        }
    }

    public final XSize getSize() {
        return this.size_;
    }

    public final void setSize(XSize sizeValue) {
        this.size_ = sizeValue;
        if (sizeValue != null) {
            sizeValue.setParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<state");
        buffer.append(" id=\"");
        buffer.append(URelaxer.escapeAttrQuot(this.getId()));
        buffer.append("\"");
        buffer.append(" entryActions=\"");
        buffer.append(URelaxer.getString(this.getEntryActions()));
        buffer.append("\"");
        buffer.append(" doActions=\"");
        buffer.append(URelaxer.getString(this.getDoActions()));
        buffer.append("\"");
        buffer.append(" exitActions=\"");
        buffer.append(URelaxer.getString(this.getExitActions()));
        buffer.append("\"");
        buffer.append(">");
        this.point_.makeTextElement(buffer);
        this.size_.makeTextElement(buffer);
        buffer.append("</state>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<state");
        buffer.print(" id=\"");
        buffer.print(URelaxer.escapeAttrQuot(this.getId()));
        buffer.print("\"");
        buffer.print(" entryActions=\"");
        buffer.print(URelaxer.getString(this.getEntryActions()));
        buffer.print("\"");
        buffer.print(" doActions=\"");
        buffer.print(URelaxer.getString(this.getDoActions()));
        buffer.print("\"");
        buffer.print(" exitActions=\"");
        buffer.print(URelaxer.getString(this.getExitActions()));
        buffer.print("\"");
        buffer.print(">");
        this.point_.makeTextElement(buffer);
        this.size_.makeTextElement(buffer);
        buffer.print("</state>");
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getEntryActionsAsString() {
        return URelaxer.getString(this.getEntryActions());
    }

    public String getDoActionsAsString() {
        return URelaxer.getString(this.getDoActions());
    }

    public String getExitActionsAsString() {
        return URelaxer.getString(this.getExitActions());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setEntryActionsByString(String string) {
        this.setEntryActions(URelaxer.getString(string));
    }

    public void setDoActionsByString(String string) {
        this.setDoActions(URelaxer.getString(string));
    }

    public void setExitActionsByString(String string) {
        this.setExitActions(URelaxer.getString(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList<Serializable> classNodes = new ArrayList<Serializable>();
        classNodes.add(this.point_);
        classNodes.add(this.size_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "state")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!XPoint.isMatchHungry(target)) {
            return false;
        }
        if (!XSize.isMatchHungry(target)) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

