/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sdeditor.model.xml.IRNode;
import sdeditor.model.xml.IStateDiagramFactory;
import sdeditor.model.xml.RStack;
import sdeditor.model.xml.StateDiagramFactory;
import sdeditor.model.xml.UJAXP;
import sdeditor.model.xml.URelaxer;
import sdeditor.model.xml.XTransition;

public class XTransitions
implements Serializable,
IRNode {
    private List transition_ = new ArrayList();
    private IRNode parentRNode_;

    public XTransitions() {
    }

    public XTransitions(RStack stack) {
        this.setup(stack);
    }

    public XTransitions(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XTransitions(Element element) {
        this.setup(element);
    }

    public XTransitions(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XTransitions(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XTransitions(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XTransitions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XTransitions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XTransitions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        IStateDiagramFactory factory = StateDiagramFactory.getFactory();
        RStack stack = new RStack(element);
        this.transition_.clear();
        while (!stack.isEmptyElement()) {
            if (!XTransition.isMatch(stack)) break;
            this.addTransition(factory.createXTransition(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("transitions");
        int size = this.transition_.size();
        int i = 0;
        while (i < size) {
            XTransition value = (XTransition)this.transition_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final XTransition[] getTransition() {
        XTransition[] array = new XTransition[this.transition_.size()];
        return this.transition_.toArray(array);
    }

    public final void setTransition(XTransition[] transition) {
        this.transition_.clear();
        this.transition_.addAll(Arrays.asList(transition));
        int i = 0;
        while (i < transition.length) {
            transition[i].setParentRNode(this);
            ++i;
        }
    }

    public final void setTransition(XTransition transition) {
        this.transition_.clear();
        this.transition_.add(transition);
        if (transition != null) {
            transition.setParentRNode(this);
        }
    }

    public final void addTransition(XTransition transition) {
        this.transition_.add(transition);
        if (transition != null) {
            transition.setParentRNode(this);
        }
    }

    public final int getTransitionCount() {
        return this.transition_.size();
    }

    public final XTransition getTransition(int index) {
        return (XTransition)this.transition_.get(index);
    }

    public final void setTransition(int index, XTransition transition) {
        this.transition_.set(index, transition);
    }

    public final void removeTransition(int index) {
        this.transition_.remove(index);
    }

    public final void removeTransition(XTransition transition) {
        this.transition_.remove(transition);
    }

    public final void clearTransition() {
        this.transition_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<transitions");
        buffer.append(">");
        int size = this.transition_.size();
        int i = 0;
        while (i < size) {
            XTransition value = (XTransition)this.transition_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</transitions>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<transitions");
        buffer.print(">");
        int size = this.transition_.size();
        int i = 0;
        while (i < size) {
            XTransition value = (XTransition)this.transition_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</transitions>");
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode getParentRNode() {
        return this.parentRNode_;
    }

    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] getRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.transition_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "transitions")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!XTransition.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XTransitions.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XTransitions.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

